/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owl.inferences;

import java.util.Arrays;
import java.util.List;
import org.semanticweb.elk.owl.inferences.AbstractElkInference;
import org.semanticweb.elk.owl.inferences.ElkInference;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkDisjointClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObject;

public class ElkDisjointClassesIntersectionInconsistencies
extends AbstractElkInference {
    public static final String NAME = "Disjoint Classes Introduction";
    private final List<? extends ElkClassExpression> expressions_;

    ElkDisjointClassesIntersectionInconsistencies(List<? extends ElkClassExpression> expressions) {
        this.expressions_ = expressions;
    }

    ElkDisjointClassesIntersectionInconsistencies(ElkClassExpression ... expressions) {
        this(Arrays.asList(expressions));
    }

    public List<? extends ElkClassExpression> getExpressions() {
        return this.expressions_;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getPremiseCount() {
        int size = this.expressions_.size();
        return (size - 1) * size / 2;
    }

    @Override
    public ElkAxiom getPremise(int index, ElkObject.Factory factory) {
        this.checkPremiseIndex(index);
        int size = this.expressions_.size();
        int sum = size - 1;
        int i = sum - 1;
        while (index >= sum) {
            sum += i;
            --i;
        }
        int firstIndex = size - i - 2;
        int secondIndex = size - (sum - index);
        return factory.getSubClassOfAxiom((ElkClassExpression)factory.getObjectIntersectionOf(this.expressions_.get(firstIndex), this.expressions_.get(secondIndex), new ElkClassExpression[0]), (ElkClassExpression)factory.getOwlNothing());
    }

    public ElkDisjointClassesAxiom getConclusion(ElkObject.Factory factory) {
        return factory.getDisjointClassesAxiom(this.expressions_);
    }

    @Override
    public <O> O accept(ElkInference.Visitor<O> visitor) {
        return visitor.visit(this);
    }

    static interface Visitor<O> {
        public O visit(ElkDisjointClassesIntersectionInconsistencies var1);
    }

    public static interface Factory {
        public ElkDisjointClassesIntersectionInconsistencies getElkDisjointClassesIntersectionInconsistencies(List<? extends ElkClassExpression> var1);

        public ElkDisjointClassesIntersectionInconsistencies getElkDisjointClassesIntersectionInconsistencies(ElkClassExpression ... var1);
    }
}

