/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owl.inferences;

import java.util.ArrayList;
import java.util.List;
import org.semanticweb.elk.owl.inferences.AbstractElkInference;
import org.semanticweb.elk.owl.inferences.ElkInference;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkSubClassOfAxiom;

public class ElkEquivalentClassesCycle
extends AbstractElkInference {
    public static final String NAME = "Class Inclusion Cycle";
    private final List<? extends ElkClassExpression> expressions_;

    ElkEquivalentClassesCycle(List<? extends ElkClassExpression> expressions) {
        this.expressions_ = expressions;
    }

    ElkEquivalentClassesCycle(ElkClassExpression first, ElkClassExpression second) {
        ArrayList<? extends ElkClassExpression> expressions = new ArrayList<ElkClassExpression>(3);
        expressions.add(first);
        expressions.add(second);
        this.expressions_ = expressions;
    }

    public List<? extends ElkClassExpression> getExpressions() {
        return this.expressions_;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getPremiseCount() {
        return this.expressions_.size();
    }

    public ElkSubClassOfAxiom getPremise(int index, ElkObject.Factory factory) {
        this.checkPremiseIndex(index);
        int first = index;
        int second = index + 1;
        if (second == this.expressions_.size()) {
            second = 0;
        }
        return factory.getSubClassOfAxiom(this.expressions_.get(first), this.expressions_.get(second));
    }

    public ElkEquivalentClassesAxiom getConclusion(ElkObject.Factory factory) {
        return factory.getEquivalentClassesAxiom(this.expressions_);
    }

    @Override
    public <O> O accept(ElkInference.Visitor<O> visitor) {
        return visitor.visit(this);
    }

    static interface Visitor<O> {
        public O visit(ElkEquivalentClassesCycle var1);
    }

    public static interface Factory {
        public ElkEquivalentClassesCycle getElkEquivalentClassesCycle(List<? extends ElkClassExpression> var1);

        public ElkEquivalentClassesCycle getElkEquivalentClassesCycle(ElkClassExpression var1, ElkClassExpression var2);
    }
}

