/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owl.inferences;

import java.util.Arrays;
import java.util.List;
import org.semanticweb.elk.owl.inferences.AbstractElkInference;
import org.semanticweb.elk.owl.inferences.ElkInference;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyOfAxiom;

public class ElkPropertyInclusionHierarchy
extends AbstractElkInference {
    public static final String NAME = "Property Hierarchy";
    private final ElkSubObjectPropertyExpression subExpression_;
    private final List<? extends ElkObjectPropertyExpression> expressions_;

    ElkPropertyInclusionHierarchy(ElkSubObjectPropertyExpression subExpression, List<? extends ElkObjectPropertyExpression> expressions) {
        this.subExpression_ = subExpression;
        this.expressions_ = expressions;
    }

    ElkPropertyInclusionHierarchy(ElkSubObjectPropertyExpression subExpression, ElkObjectPropertyExpression ... expressions) {
        this(subExpression, Arrays.asList(expressions));
    }

    public ElkSubObjectPropertyExpression getSubExpression() {
        return this.subExpression_;
    }

    public List<? extends ElkObjectPropertyExpression> getExpressions() {
        return this.expressions_;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getPremiseCount() {
        return this.expressions_.size();
    }

    public ElkSubObjectPropertyOfAxiom getPremise(int index, ElkObject.Factory factory) {
        this.checkPremiseIndex(index);
        if (index == 0) {
            return factory.getSubObjectPropertyOfAxiom(this.subExpression_, this.expressions_.get(0));
        }
        return factory.getSubObjectPropertyOfAxiom((ElkSubObjectPropertyExpression)this.expressions_.get(index - 1), this.expressions_.get(index));
    }

    public ElkSubObjectPropertyOfAxiom getConclusion(ElkObject.Factory factory) {
        return factory.getSubObjectPropertyOfAxiom(this.subExpression_, this.expressions_.get(this.expressions_.size() - 1));
    }

    public <O> O accept(Visitor<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(ElkInference.Visitor<O> visitor) {
        return visitor.visit(this);
    }

    static interface Visitor<O> {
        public O visit(ElkPropertyInclusionHierarchy var1);
    }

    public static interface Factory {
        public ElkPropertyInclusionHierarchy getElkPropertyInclusionHierarchy(ElkSubObjectPropertyExpression var1, ElkObjectPropertyExpression ... var2);

        public ElkPropertyInclusionHierarchy getElkPropertyInclusionHierarchy(ElkSubObjectPropertyExpression var1, List<? extends ElkObjectPropertyExpression> var2);
    }
}

