/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.proofs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.liveontologies.puli.BaseProof;
import org.liveontologies.puli.Inference;
import org.liveontologies.puli.Inferences;
import org.liveontologies.puli.ModifiableProof;
import org.liveontologies.puli.Proof;
import org.semanticweb.elk.exceptions.ElkException;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.proofs.TracingInferenceWrap;
import org.semanticweb.elk.reasoner.Reasoner;
import org.semanticweb.elk.reasoner.entailments.model.Entailment;
import org.semanticweb.elk.reasoner.entailments.model.EntailmentInference;
import org.semanticweb.elk.reasoner.entailments.model.HasReason;
import org.semanticweb.elk.reasoner.proof.ReasonerProof;
import org.semanticweb.elk.reasoner.query.VerifiableQueryResult;
import org.semanticweb.elk.reasoner.tracing.Conclusion;
import org.semanticweb.elk.reasoner.tracing.TracingInference;
import org.semanticweb.elk.reasoner.tracing.TracingProof;
import org.semanticweb.elk.util.collections.ArrayHashSet;

public class InternalProof
implements Proof<Inference<Object>> {
    private final Reasoner reasoner_;
    private final ElkAxiom goal_;
    private final ModifiableProof<Inference<Object>> proof_ = new BaseProof();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalProof(Reasoner reasoner, ElkAxiom goal) throws ElkException {
        this.reasoner_ = reasoner;
        this.goal_ = goal;
        VerifiableQueryResult result = reasoner.checkEntailment(goal);
        try {
            Entailment entailment = result.getEntailment();
            if (entailment == null) {
                return;
            }
            this.proof_.produce(Inferences.create((String)"Goal inference", (Object)this.goal_, Arrays.asList(entailment)));
            this.processEntailment(entailment, (ReasonerProof<EntailmentInference>)result.getEvidence(false));
        }
        finally {
            result.unlock();
        }
    }

    private void processEntailment(Entailment goal, ReasonerProof<EntailmentInference> evidence) throws ElkException {
        Conclusion conclusion;
        Entailment entailment;
        ArrayHashSet entailmentDone = new ArrayHashSet();
        LinkedList<Entailment> entailmentToDo = new LinkedList<Entailment>();
        ArrayHashSet tracingDone = new ArrayHashSet();
        LinkedList<Conclusion> tracingToDo = new LinkedList<Conclusion>();
        if (entailmentDone.add(goal)) {
            entailmentToDo.add(goal);
        }
        while ((entailment = (Entailment)entailmentToDo.poll()) != null) {
            for (EntailmentInference inf : evidence.getInferences((Object)entailment)) {
                Conclusion reason = this.getReason(inf);
                List premises = inf.getPremises();
                ArrayList<Conclusion> newPremises = new ArrayList<Conclusion>(premises.size() + (reason == null ? 0 : 1));
                newPremises.addAll(premises);
                if (reason != null) {
                    if (tracingDone.add(reason)) {
                        tracingToDo.add(reason);
                    }
                    newPremises.add(reason);
                }
                this.proof_.produce(Inferences.create((String)inf.getName(), (Object)inf.getConclusion(), newPremises));
                for (Entailment premise : inf.getPremises()) {
                    if (!entailmentDone.add(premise)) continue;
                    entailmentToDo.add(premise);
                }
            }
        }
        TracingProof tracingProof = this.reasoner_.getProof();
        while ((conclusion = (Conclusion)tracingToDo.poll()) != null) {
            for (TracingInference inf : tracingProof.getInferences((Object)conclusion)) {
                this.proof_.produce((Inference)new TracingInferenceWrap(inf));
                for (Conclusion premise : inf.getPremises()) {
                    if (!tracingDone.add(premise)) continue;
                    tracingToDo.add(premise);
                }
            }
        }
    }

    private Conclusion getReason(EntailmentInference entailmentInference) {
        Object r;
        Conclusion reason = null;
        if (entailmentInference instanceof HasReason && (r = ((HasReason)entailmentInference).getReason()) instanceof Conclusion) {
            reason = (Conclusion)r;
        }
        return reason;
    }

    public Collection<? extends Inference<Object>> getInferences(Object conclusion) {
        return this.proof_.getInferences(conclusion);
    }
}

