/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.collections;

import java.util.Collection;
import java.util.Collections;
import org.semanticweb.elk.util.collections.ArrayHashMap;
import org.semanticweb.elk.util.collections.Multimap;

public abstract class AbstractHashMultimap<Key, Value>
extends ArrayHashMap<Key, Collection<Value>>
implements Multimap<Key, Value> {
    protected abstract Collection<Value> newRecord();

    public AbstractHashMultimap() {
    }

    public AbstractHashMultimap(int i) {
        super(i);
    }

    @Override
    public boolean contains(Key key, Value value) {
        Collection record = (Collection)super.get(key);
        if (record == null) {
            return false;
        }
        return record.contains(value);
    }

    @Override
    public boolean add(Key key, Value value) {
        Collection<Value> record = (Collection<Value>)super.get(key);
        if (record == null) {
            record = this.newRecord();
            this.put(key, record);
        }
        return record.add(value);
    }

    @Override
    public Collection<Value> get(Object key) {
        Collection result = (Collection)super.get(key);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public Collection<Value> getValues(Object key) {
        return (Collection)super.get(key);
    }

    @Override
    public boolean remove(Object key, Object value) {
        Collection record = (Collection)super.get(key);
        if (record == null) {
            return false;
        }
        if (record.remove(value)) {
            if (record.isEmpty()) {
                super.remove(key);
            }
            return true;
        }
        return false;
    }
}

