/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.collections;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.semanticweb.elk.util.collections.DirectAccess;
import org.semanticweb.elk.util.collections.LinearProbing;
import org.semanticweb.elk.util.collections.LinearProbingIterator;

public class ArrayHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    protected volatile transient K[] keys;
    protected volatile transient V[] values;
    protected transient int size;

    public ArrayHashMap(int initialCapacity) {
        int capacity = LinearProbing.getInitialCapacity(initialCapacity);
        this.keys = new Object[capacity];
        this.values = new Object[capacity];
        this.size = 0;
    }

    public ArrayHashMap() {
        int capacity = 16;
        this.keys = new Object[capacity];
        this.values = new Object[capacity];
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return LinearProbing.contains(this.keys, key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        V[] v = this.values;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!value.equals(v[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        V[] v;
        K[] k;
        if (key == null) {
            throw new NullPointerException();
        }
        while ((k = this.keys).length != (v = this.values).length) {
        }
        int pos = LinearProbing.getPosition(k, key);
        if (k[pos] == null) {
            return null;
        }
        return v[pos];
    }

    private static <K, V> V putKeyValue(K[] keys, V[] values, K key, V value) {
        int pos = LinearProbing.getPosition(keys, key);
        if (keys[pos] == null) {
            keys[pos] = key;
            values[pos] = value;
            return null;
        }
        V oldValue = values[pos];
        values[pos] = value;
        return oldValue;
    }

    private static <K, V> V removeEntry(K[] keys, V[] values, Object key) {
        int pos = LinearProbing.getPosition(keys, key);
        if (keys[pos] == null) {
            return null;
        }
        V result = values[pos];
        LinearProbing.remove(keys, values, pos);
        return result;
    }

    private void enlarge() {
        int oldCapacity = this.keys.length;
        if (oldCapacity == 0x40000000) {
            throw new IllegalArgumentException("Map cannot grow beyond capacity: 1073741824");
        }
        K[] oldKeys = this.keys;
        V[] oldValues = this.values;
        int newCapacity = oldCapacity << 1;
        Object[] newKeys = new Object[newCapacity];
        Object[] newValues = new Object[newCapacity];
        for (int i = 0; i < oldCapacity; ++i) {
            K key = oldKeys[i];
            if (key == null) continue;
            ArrayHashMap.putKeyValue(newKeys, newValues, key, oldValues[i]);
        }
        this.keys = newKeys;
        this.values = newValues;
    }

    private void shrink() {
        int oldCapacity = this.keys.length;
        if (oldCapacity <= 16) {
            return;
        }
        K[] oldKeys = this.keys;
        V[] oldValues = this.values;
        int newCapacity = oldCapacity >> 1;
        Object[] newKeys = new Object[newCapacity];
        Object[] newValues = new Object[newCapacity];
        for (int i = 0; i < oldCapacity; ++i) {
            K key = oldKeys[i];
            if (key == null) continue;
            ArrayHashMap.putKeyValue(newKeys, newValues, key, oldValues[i]);
        }
        this.keys = newKeys;
        this.values = newValues;
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException();
        }
        V result = ArrayHashMap.putKeyValue(this.keys, this.values, key, value);
        if (result == null && ++this.size == LinearProbing.getUpperSize(this.keys.length)) {
            this.enlarge();
        }
        return result;
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        V result = ArrayHashMap.removeEntry(this.keys, this.values, key);
        if (result != null && --this.size == LinearProbing.getLowerSize(this.keys.length)) {
            this.shrink();
        }
        return result;
    }

    @Override
    public void clear() {
        int capacity = this.keys.length >> 2;
        if (capacity == 0) {
            capacity = 1;
        }
        this.size = 0;
        this.keys = new Object[capacity];
        this.values = new Object[capacity];
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<V> values() {
        return new ValueCollection();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Object k = ((Map.Entry)o).getKey();
            return ArrayHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Object k = ((Map.Entry)o).getKey();
            return ArrayHashMap.this.remove(k) != null;
        }

        @Override
        public int size() {
            return ArrayHashMap.this.size;
        }

        @Override
        public void clear() {
            ArrayHashMap.this.clear();
        }
    }

    class Entry
    implements Map.Entry<K, V> {
        final EntryIterator iterator;
        final int cursor;

        Entry(EntryIterator iterator, int cursor) {
            this.iterator = iterator;
            this.cursor = cursor;
        }

        @Override
        public K getKey() {
            return this.iterator.dataSnapshot[this.cursor];
        }

        @Override
        public V getValue() {
            return this.iterator.valuesSnapshot[this.cursor];
        }

        @Override
        public V setValue(V value) {
            Object previous = this.iterator.valuesSnapshot[this.cursor];
            this.iterator.valuesSnapshot[this.cursor] = value;
            return previous;
        }
    }

    private class EntryIterator
    extends LinearProbingIterator<K, Map.Entry<K, V>> {
        final V[] valuesSnapshot;

        EntryIterator() {
            super(ArrayHashMap.this.keys, ArrayHashMap.this.size);
            this.valuesSnapshot = ArrayHashMap.this.values;
            this.init();
        }

        @Override
        void checkSize(int expectedSize) {
            if (expectedSize != ArrayHashMap.this.size) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        void remove(int pos) {
            LinearProbing.remove(this.dataSnapshot, ArrayHashMap.this.values, pos);
            --ArrayHashMap.this.size;
        }

        @Override
        Map.Entry<K, V> getValue(K element, int pos) {
            return new Entry(this, pos);
        }
    }

    private final class ValueCollection
    extends AbstractCollection<V>
    implements DirectAccess<V> {
        private ValueCollection() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return ArrayHashMap.this.size;
        }

        @Override
        public void clear() {
            ArrayHashMap.this.clear();
        }

        @Override
        public V[] getRawData() {
            return ArrayHashMap.this.values;
        }
    }

    private class ValueIterator
    extends LinearProbingIterator<V, V> {
        ValueIterator() {
            super(ArrayHashMap.this.values, ArrayHashMap.this.size);
            this.init();
        }

        @Override
        void checkSize(int expectedSize) {
            if (expectedSize != ArrayHashMap.this.size) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        void remove(int pos) {
            LinearProbing.remove(ArrayHashMap.this.keys, this.dataSnapshot, pos);
            --ArrayHashMap.this.size;
        }

        @Override
        V getValue(V element, int pos) {
            return element;
        }
    }

    private final class KeySet
    extends AbstractSet<K>
    implements DirectAccess<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean contains(Object o) {
            return ArrayHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return ArrayHashMap.this.remove(o) != null;
        }

        @Override
        public int size() {
            return ArrayHashMap.this.size;
        }

        @Override
        public void clear() {
            ArrayHashMap.this.clear();
        }

        @Override
        public K[] getRawData() {
            return ArrayHashMap.this.keys;
        }
    }

    private class KeyIterator
    extends LinearProbingIterator<K, K> {
        KeyIterator() {
            super(ArrayHashMap.this.keys, ArrayHashMap.this.size);
            this.init();
        }

        @Override
        void checkSize(int expectedSize) {
            if (expectedSize != ArrayHashMap.this.size) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        void remove(int pos) {
            LinearProbing.remove(this.dataSnapshot, ArrayHashMap.this.values, pos);
            --ArrayHashMap.this.size;
        }

        @Override
        K getValue(K element, int pos) {
            return element;
        }
    }
}

