/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.collections;

import java.util.Map;
import org.semanticweb.elk.util.collections.ArrayHashMap;
import org.semanticweb.elk.util.collections.Evictor;
import org.semanticweb.elk.util.collections.Evictors;
import org.semanticweb.elk.util.collections.RecencyEvictor;
import org.semanticweb.elk.util.statistics.Stat;

public class CapacityBalancingEvictor<E>
extends RecencyEvictor<E> {
    private final Map<E, Integer> lastQueryTicks_ = new ArrayHashMap<E, Integer>();
    private final QuantileEstimator quantileEstimator_;
    private final int balanceAfterNRepeatedQueries_;
    private int tick_ = Integer.MIN_VALUE;
    private int nRepeatedQueriesToBalance_;

    CapacityBalancingEvictor(double balance, int balanceAfterNRepeatedQueries, double loadFactor, int initialCapacity) {
        super(initialCapacity, loadFactor);
        this.quantileEstimator_ = new QuantileEstimator(balance, initialCapacity);
        this.balanceAfterNRepeatedQueries_ = balanceAfterNRepeatedQueries;
        this.nRepeatedQueriesToBalance_ = balanceAfterNRepeatedQueries;
        this.stats = new Stats();
    }

    @Override
    public void add(E element) {
        Integer lastQueryTick = this.lastQueryTicks_.get(element);
        if (lastQueryTick != null) {
            --this.nRepeatedQueriesToBalance_;
            int queryAge = this.tick_ - lastQueryTick;
            double estimation = this.quantileEstimator_.next(queryAge);
            if (this.nRepeatedQueriesToBalance_ == 0) {
                this.nRepeatedQueriesToBalance_ = this.balanceAfterNRepeatedQueries_;
                this.setCapacity((int)Math.min(Math.max(0.0, estimation), 2.147483647E9));
            }
        }
        this.lastQueryTicks_.put(element, this.tick_);
        ++this.tick_;
        super.add(element);
    }

    @Stat(name="nDifferentQueries")
    public int getNumberOfDifferentQueries() {
        return this.lastQueryTicks_.size();
    }

    public static Builder builder() {
        return new Builder();
    }

    protected class Stats
    extends RecencyEvictor.Stats {
        protected Stats() {
            super(CapacityBalancingEvictor.this);
        }

        @Stat
        public int nDifferentQueries() {
            return CapacityBalancingEvictor.this.lastQueryTicks_.size();
        }
    }

    public static class Builder
    extends ProtectedBuilder<Builder>
    implements Evictor.Builder {
        @Override
        protected Builder convertThis() {
            return this;
        }

        public static Builder valueOf(String value) {
            String[] args = Evictors.parseArgs(value, CapacityBalancingEvictor.class, 4);
            String capacityArg = args[0].trim();
            String loadFactorArg = args[1].trim();
            String balanceArg = args[2].trim();
            String balanceAfterNRepeatedQueriesArg = args[3].trim();
            int capacity = capacityArg.isEmpty() ? 128 : Integer.valueOf(capacityArg);
            double loadFactor = loadFactorArg.isEmpty() ? 0.75 : Double.valueOf(loadFactorArg);
            double balance = balanceArg.isEmpty() ? 0.8 : Double.valueOf(balanceArg);
            int balanceAfterNRepeatedQueries = balanceAfterNRepeatedQueriesArg.isEmpty() ? 100 : Integer.valueOf(balanceAfterNRepeatedQueriesArg);
            return (Builder)((Builder)((Builder)((Builder)new Builder().capacity(capacity < 0 ? Integer.MAX_VALUE : capacity)).loadFactor(loadFactor)).balance(balance)).balanceAfterNRepeatedQueries(balanceAfterNRepeatedQueries);
        }

        public String toString() {
            return String.format("%s(%d,%f,%f,%d)", CapacityBalancingEvictor.class.getName(), this.capacity_, this.loadFactor_, this.balance_, this.balanceAfterNRepeatedQueries_);
        }
    }

    protected static abstract class ProtectedBuilder<B extends ProtectedBuilder<B>>
    extends RecencyEvictor.ProtectedBuilder<B> {
        public static final double DEFAULT_BALANCE = 0.8;
        public static final int DEFAULT_BALANCE_AFTER_N_REPEATED_QUERIES = 100;
        protected double balance_ = 0.8;
        protected int balanceAfterNRepeatedQueries_ = 100;

        protected ProtectedBuilder() {
        }

        public B balance(double balance) throws IllegalArgumentException {
            if (0.0 > balance || balance > 1.0) {
                throw new IllegalArgumentException("Balance must be between 0 and 1 inclusive!");
            }
            this.balance_ = balance;
            return (B)this.convertThis();
        }

        public B balanceAfterNRepeatedQueries(int balanceAfterNRepeatedQueries) throws IllegalArgumentException {
            if (1 > balanceAfterNRepeatedQueries) {
                throw new IllegalArgumentException("Capacity can be balanced only after positive number of repeated queries!");
            }
            this.balanceAfterNRepeatedQueries_ = balanceAfterNRepeatedQueries;
            return (B)this.convertThis();
        }

        @Override
        public <E> Evictor<E> build() {
            return new CapacityBalancingEvictor(this.balance_, this.balanceAfterNRepeatedQueries_, this.loadFactor_, this.capacity_);
        }

        @Override
        protected abstract B convertThis();
    }

    private static class QuantileEstimator {
        private final double q_;
        private boolean first_ = true;
        private double estimation_ = 0.0;
        private double absoluteDeviationSum_ = 0.0;
        private long count_ = 0L;

        public QuantileEstimator(double q) {
            this.q_ = q;
        }

        public QuantileEstimator(double q, double initialValue) {
            this(q);
            this.next(initialValue);
        }

        public double next(double x) {
            ++this.count_;
            if (this.first_) {
                this.estimation_ = x;
                this.first_ = false;
            } else {
                double eta = 1.5 * this.absoluteDeviationSum_ / (double)(this.count_ * this.count_);
                this.estimation_ += eta * (Math.signum(x - this.estimation_) + 2.0 * this.q_ - 1.0);
            }
            this.absoluteDeviationSum_ += Math.abs(x - this.estimation_);
            return this.estimation_;
        }
    }
}

