/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;

public interface FList<E>
extends Iterable<E> {
    public E getHead();

    public FList<E> getTail();

    public static class Hash {
        public static int hashCode(FList<?> list) {
            int result = 0;
            while (list != null) {
                result = 31 * list.getHead().hashCode();
                list = list.getTail();
            }
            return result;
        }
    }

    public static class Equality {
        public static boolean equals(FList<?> first, Object second) {
            if (second instanceof FList) {
                return Equality.equals(first, (FList)second);
            }
            return false;
        }

        private static boolean equals(FList<?> first, FList<?> second) {
            while (first != second) {
                if (first == null || second == null) {
                    return false;
                }
                if (!first.getHead().equals(second.getHead())) {
                    return false;
                }
                first = first.getTail();
                second = second.getTail();
            }
            return true;
        }
    }

    public static class FListIterator<E>
    implements Iterator<E> {
        private FList<E> list_;

        public FListIterator(FList<E> list) {
            this.list_ = list;
        }

        @Override
        public boolean hasNext() {
            return this.list_ != null;
        }

        @Override
        public E next() {
            if (this.list_ == null) {
                throw new NoSuchElementException();
            }
            E result = this.list_.getHead();
            this.list_ = this.list_.getTail();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("The list cannot be modified!");
        }
    }
}

