/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.collections;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class LazyCollectionMinusSet<E>
extends AbstractCollection<E> {
    private final Collection<? extends E> collection_;
    private final Set<? extends E> set_;

    public LazyCollectionMinusSet(Collection<? extends E> collection, Set<? extends E> set) {
        this.collection_ = collection;
        this.set_ = set;
    }

    @Override
    public boolean isEmpty() {
        return this.set_.containsAll(this.collection_);
    }

    @Override
    public boolean contains(Object o) {
        return this.collection_.contains(o) && !this.set_.contains(o);
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private final Iterator<? extends E> iter_;
            private E next_;
            {
                this.iter_ = LazyCollectionMinusSet.this.collection_.iterator();
                this.next_ = null;
            }

            @Override
            public boolean hasNext() {
                while (this.next_ == null && this.iter_.hasNext()) {
                    Object elem = this.iter_.next();
                    this.next_ = LazyCollectionMinusSet.this.set_.contains(elem) ? null : elem;
                }
                return this.next_ != null;
            }

            @Override
            public E next() {
                if (this.next_ != null) {
                    return this.giveAway();
                }
                if (this.hasNext()) {
                    return this.giveAway();
                }
                throw new NoSuchElementException();
            }

            private E giveAway() {
                Object elem = this.next_;
                this.next_ = null;
                return elem;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.collection_.size() - this.set_.size();
    }
}

