/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.collections;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.semanticweb.elk.util.collections.AbstractEvictor;
import org.semanticweb.elk.util.collections.Evictor;
import org.semanticweb.elk.util.collections.Evictors;
import org.semanticweb.elk.util.statistics.Stat;

public class NQEvictor<E>
extends AbstractEvictor<E> {
    private static final int DEFAULT_ELEMENTS_CAPACITY_ = 128;
    private static final float DEFAULT_ELEMENTS_LOAD_FACTOR_ = 0.75f;
    private final List<LinkedHashMap<E, Boolean>> elements_;
    private final List<Integer> capacities_;
    private final List<Double> loadFactors_;

    NQEvictor(List<Integer> capacities, List<Double> loadFactors) {
        this.elements_ = new ArrayList<LinkedHashMap<E, Boolean>>(capacities.size());
        for (int i = 0; i < capacities.size(); ++i) {
            this.elements_.add(new LinkedHashMap(128, 0.75f, true));
        }
        this.capacities_ = capacities;
        this.loadFactors_ = loadFactors;
        this.stats = new Stats();
    }

    @Override
    public void add(E element) {
        for (int i = 0; i < this.elements_.size() - 1; ++i) {
            LinkedHashMap<E, Boolean> iThQueue = this.elements_.get(i);
            if (iThQueue.remove(element) == null) continue;
            this.elements_.get(i + 1).put(element, true);
            return;
        }
        LinkedHashMap<E, Boolean> lastQueue = this.elements_.get(this.elements_.size() - 1);
        if (lastQueue.containsKey(element)) {
            lastQueue.put(element, true);
            return;
        }
        this.elements_.get(0).put(element, true);
    }

    @Override
    public Iterator<E> evict(Predicate<E> retain) {
        Preconditions.checkNotNull(retain);
        for (int i = this.capacities_.size() - 1; i > 0; --i) {
            LinkedHashMap<E, Boolean> level = this.elements_.get(i);
            LinkedHashMap<E, Boolean> lowerLevel = this.elements_.get(i - 1);
            int capacity = this.capacities_.get(i);
            double loadFactor = this.loadFactors_.get(i);
            if (level.size() <= capacity) continue;
            int goalCapacity = (int)((double)capacity * loadFactor);
            Iterator<E> iterator = level.keySet().iterator();
            while (iterator.hasNext() && level.size() > goalCapacity) {
                E element = iterator.next();
                lowerLevel.put(element, true);
                iterator.remove();
            }
        }
        ArrayList<E> evicted = new ArrayList<E>();
        LinkedHashMap<E, Boolean> firstLevel = this.elements_.get(0);
        int capacity = this.capacities_.get(0);
        double loadFactor = this.loadFactors_.get(0);
        if (firstLevel.size() <= capacity) {
            return evicted.iterator();
        }
        int goalCapacity = (int)((double)capacity * loadFactor);
        Iterator<E> iterator = firstLevel.keySet().iterator();
        while (iterator.hasNext() && firstLevel.size() > goalCapacity) {
            E element = iterator.next();
            if (retain.apply(element)) continue;
            evicted.add(element);
            iterator.remove();
        }
        return evicted.iterator();
    }

    public int getN() {
        return this.capacities_.size();
    }

    public int getCapacity(int index) {
        return this.capacities_.get(index);
    }

    public int setCapacity(int index, int capacity) {
        if (0 > capacity) {
            throw new IllegalArgumentException("Capacity cannot be negative!");
        }
        return this.capacities_.set(index, capacity);
    }

    public static Builder builder() {
        return new Builder();
    }

    protected class Stats {
        protected Stats() {
        }

        @Stat
        public String levelSizes() {
            StringBuilder result = new StringBuilder("" + ((LinkedHashMap)NQEvictor.this.elements_.get(0)).size());
            for (int i = 1; i < NQEvictor.this.elements_.size(); ++i) {
                result.append("_").append(((LinkedHashMap)NQEvictor.this.elements_.get(i)).size());
            }
            return result.toString();
        }
    }

    public static class Builder
    extends ProtectedBuilder<Builder>
    implements Evictor.Builder {
        @Override
        protected Builder convertThis() {
            return this;
        }

        public static Builder valueOf(String value) {
            String[] args = Evictors.parseArgs(value, NQEvictor.class, null);
            if (args.length % 2 != 0) {
                throw new IllegalArgumentException("The number of arguments must be even! value: " + value);
            }
            Builder builder = new Builder();
            for (int i = 0; i < args.length; i += 2) {
                String capacityArg = args[i].trim();
                String loadFactorArg = args[i + 1].trim();
                int capacity = capacityArg.isEmpty() ? 128 : Integer.valueOf(capacityArg);
                double loadFactor = loadFactorArg.isEmpty() ? 0.75 : Double.valueOf(loadFactorArg);
                builder.addLevel(capacity < 0 ? Integer.MAX_VALUE : capacity, loadFactor);
            }
            return builder;
        }

        public String toString() {
            StringBuilder result = new StringBuilder(NQEvictor.class.getName()).append("(");
            for (int i = 0; i < this.capacities.size(); ++i) {
                if (i > 0) {
                    result.append(",");
                }
                result.append(this.capacities.get(i)).append(",").append(this.loadFactors.get(i));
            }
            return result.append(")").toString();
        }
    }

    protected static abstract class ProtectedBuilder<B extends ProtectedBuilder<B>> {
        public static final int DEFAULT_CAPACITY = 128;
        public static final double DEFAULT_LOAD_FACTOR = 0.75;
        protected final List<Integer> capacities = new ArrayList<Integer>();
        protected final List<Double> loadFactors = new ArrayList<Double>();

        protected ProtectedBuilder() {
        }

        public B addLevel(int capacity, double loadFactor) throws IllegalArgumentException {
            if (0 > capacity) {
                throw new IllegalArgumentException("Capacity cannot be negative!");
            }
            if (0.0 > loadFactor || loadFactor > 1.0) {
                throw new IllegalArgumentException("Load factor must be between 0 and 1 inclusive!");
            }
            this.capacities.add(capacity);
            this.loadFactors.add(loadFactor);
            return this.convertThis();
        }

        public B addLevel(int capacity) throws IllegalArgumentException {
            return this.addLevel(capacity, 0.75);
        }

        public B addLevel(double loadFactor) throws IllegalArgumentException {
            return this.addLevel(128, loadFactor);
        }

        public B addLevel() {
            return this.addLevel(128);
        }

        public <E> NQEvictor<E> build() {
            if (this.capacities.isEmpty()) {
                this.addLevel();
            }
            return new NQEvictor(this.capacities, this.loadFactors);
        }

        protected abstract B convertThis();
    }
}

