/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.collections;

import java.io.IOException;
import java.io.Writer;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.semanticweb.elk.util.collections.Condition;
import org.semanticweb.elk.util.collections.Multimap;

public class Operations {
    public static final Multimap<?, ?> EMPTY_MULTIMAP = new Multimap<Object, Object>(){

        @Override
        public boolean contains(Object key, Object value) {
            return false;
        }

        @Override
        public boolean add(Object key, Object value) {
            throw new UnsupportedOperationException("The Empty multimap cannot be modified!");
        }

        @Override
        public Collection<Object> get(Object key) {
            return Collections.emptySet();
        }

        @Override
        public boolean remove(Object key, Object value) {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Set<Object> keySet() {
            return Collections.emptySet();
        }

        @Override
        public void clear() {
        }

        @Override
        public Collection<Object> remove(Object key) {
            return Collections.emptySet();
        }
    };

    public static <S, T> Multimap<S, T> emptyMultimap() {
        return EMPTY_MULTIMAP;
    }

    @SafeVarargs
    public static <T> Iterable<T> concat(Iterable<? extends T> ... inputs) {
        return Operations.concat(Arrays.asList(inputs));
    }

    public static <T> Iterator<T> singletonIterator(final T element) {
        return new Iterator<T>(){
            boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public T next() {
                this.hasNext = false;
                return element;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Iterable<T> singleton(final T element) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Operations.singletonIterator(element);
            }
        };
    }

    public static <T> Iterable<T> concat(final Iterable<? extends Iterable<? extends T>> inputs) {
        assert (inputs != null);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    Iterator<? extends Iterable<? extends T>> outer;
                    Iterator<? extends T> inner;
                    boolean hasNext;
                    {
                        this.outer = inputs.iterator();
                        this.hasNext = this.advance();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.hasNext;
                    }

                    @Override
                    public T next() {
                        if (this.hasNext) {
                            Object result = this.inner.next();
                            this.hasNext = this.advance();
                            return result;
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    boolean advance() {
                        while (true) {
                            if (this.inner != null && this.inner.hasNext()) {
                                return true;
                            }
                            if (!this.outer.hasNext()) break;
                            this.inner = this.outer.next().iterator();
                        }
                        return false;
                    }
                };
            }
        };
    }

    public static <T> Iterator<T> synchronize(final Iterator<?> first, final Iterator<? extends T> second) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return first.hasNext() && second.hasNext();
            }

            @Override
            public T next() {
                first.next();
                return second.next();
            }
        };
    }

    public static <T> Iterable<ArrayList<T>> split(final Iterable<? extends T> elements, final int batchSize) {
        return new Iterable<ArrayList<T>>(){

            @Override
            public Iterator<ArrayList<T>> iterator() {
                return new Iterator<ArrayList<T>>(){
                    final Iterator<? extends T> elementsIterator;
                    {
                        this.elementsIterator = elements.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.elementsIterator.hasNext();
                    }

                    @Override
                    public ArrayList<T> next() {
                        ArrayList nextBatch = new ArrayList(batchSize);
                        int count = 0;
                        while (count++ < batchSize && this.elementsIterator.hasNext()) {
                            nextBatch.add(this.elementsIterator.next());
                        }
                        return nextBatch;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Deletion is not supported");
                    }
                };
            }
        };
    }

    public static <T> Collection<ArrayList<T>> split(final Collection<? extends T> elements, final int batchSize) {
        return new AbstractCollection<ArrayList<T>>(){

            @Override
            public Iterator<ArrayList<T>> iterator() {
                Iterable iterable = Operations.split(elements, batchSize);
                return iterable.iterator();
            }

            @Override
            public int size() {
                return (elements.size() + batchSize - 1) / batchSize;
            }
        };
    }

    public static <T> Collection<T> getCollection(final Iterable<T> iterable, final int size) {
        return new AbstractCollection<T>(){

            @Override
            public Iterator<T> iterator() {
                return iterable.iterator();
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    public static <T> Iterable<T> filter(final Iterable<? extends T> input, final Condition<? super T> condition) {
        assert (input != null);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    Iterator<? extends T> i;
                    T next;
                    boolean hasNext;
                    {
                        this.i = input.iterator();
                        this.hasNext = this.advance();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.hasNext;
                    }

                    @Override
                    public T next() {
                        if (this.hasNext) {
                            Object result = this.next;
                            this.hasNext = this.advance();
                            return result;
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }

                    boolean advance() {
                        while (this.i.hasNext()) {
                            this.next = this.i.next();
                            if (!condition.holds(this.next)) continue;
                            return true;
                        }
                        return false;
                    }
                };
            }
        };
    }

    public static <T, S> Iterable<T> filter(Iterable<S> input, final Class<T> type) {
        return Operations.filter(input, new Condition<S>(){

            @Override
            public boolean holds(S element) {
                return type.isInstance(element);
            }
        });
    }

    public static <T> Set<T> filter(final Set<? extends T> input, final Condition<? super T> condition, final int size) {
        return new Set<T>(){

            @Override
            public int size() {
                return size;
            }

            @Override
            public boolean isEmpty() {
                return size == 0;
            }

            @Override
            public boolean contains(Object o) {
                if (!input.contains(o)) {
                    return false;
                }
                Object elem = null;
                try {
                    elem = o;
                }
                catch (ClassCastException cce) {
                    return false;
                }
                return condition.holds(elem);
            }

            @Override
            public Iterator<T> iterator() {
                Iterable iterable = Operations.filter(input, condition);
                return iterable.iterator();
            }

            @Override
            public Object[] toArray() {
                Object[] result = new Object[size];
                int i = 0;
                for (Object o : Operations.filter(input, condition)) {
                    result[i++] = o;
                }
                return result;
            }

            @Override
            public <S> S[] toArray(S[] a) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean add(T e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                for (Object o : c) {
                    if (!this.contains(o)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends T> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <I, O> Iterable<O> map(final Iterable<I> input, final Transformation<? super I, O> transformation) {
        assert (input != null);
        return new Iterable<O>(){

            @Override
            public Iterator<O> iterator() {
                return new Iterator<O>(){
                    Iterator<I> i;
                    O next;
                    boolean hasNext;
                    {
                        this.i = input.iterator();
                        this.hasNext = this.advance();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.hasNext;
                    }

                    @Override
                    public O next() {
                        if (this.hasNext) {
                            Object result = this.next;
                            this.hasNext = this.advance();
                            return result;
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }

                    boolean advance() {
                        while (this.i.hasNext()) {
                            this.next = transformation.transform(this.i.next());
                            if (this.next == null) continue;
                            return true;
                        }
                        return false;
                    }
                };
            }
        };
    }

    public static <I, O> Iterable<O> mapConcat(final Iterable<I> input, final Transformation<? super I, Iterable<O>> transformation) {
        assert (input != null);
        return new Iterable<O>(){

            @Override
            public Iterator<O> iterator() {
                return Operations.mapConcat(input.iterator(), transformation);
            }
        };
    }

    public static <I, O> Collection<O> map(final Collection<I> input, final Transformation<? super I, O> transformation) {
        assert (input != null);
        return new AbstractCollection<O>(){

            @Override
            public Iterator<O> iterator() {
                return Operations.map(input.iterator(), transformation);
            }

            @Override
            public int size() {
                return input.size();
            }
        };
    }

    public static <I, O> Iterator<O> map(final Iterator<I> input, final Transformation<? super I, O> transformation) {
        return new Iterator<O>(){
            O next;
            boolean hasNext = this.advance();

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public O next() {
                if (this.hasNext) {
                    Object result = this.next;
                    this.hasNext = this.advance();
                    return result;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                input.remove();
            }

            boolean advance() {
                while (input.hasNext()) {
                    this.next = transformation.transform(input.next());
                    if (this.next == null) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <I, O> Iterator<O> mapConcat(final Iterator<I> input, final Transformation<? super I, Iterable<O>> transformation) {
        return new Iterator<O>(){
            Iterator<O> nextIter = Collections.emptyList().iterator();
            O next;

            @Override
            public boolean hasNext() {
                while (true) {
                    if (this.next != null) {
                        return true;
                    }
                    if (this.nextIter.hasNext()) {
                        this.next = this.nextIter.next();
                        return true;
                    }
                    if (!input.hasNext()) break;
                    this.nextIter = ((Iterable)transformation.transform(input.next())).iterator();
                }
                return false;
            }

            @Override
            public O next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object result = this.next;
                this.next = null;
                return result;
            }

            @Override
            public void remove() {
                input.remove();
            }
        };
    }

    public static <K, V> void dumpDiff(Multimap<K, V> first, Multimap<K, V> second, Writer writer, String prefix) throws IOException {
        for (K key : first.keySet()) {
            Collection<V> firstValues = first.get(key);
            Collection<V> secondValues = second.get(key);
            Operations.dumpDiff(firstValues, secondValues, writer, prefix + key + "->");
        }
    }

    public static <T> void dumpDiff(Collection<T> first, Collection<T> second, Writer writer, String prefix) throws IOException {
        for (T element : first) {
            if (second.contains(element)) continue;
            writer.append(prefix + element + "\n");
        }
    }

    public static <I, O> Set<O> map(final Set<? extends I> input, final FunctorEx<I, O> functor) {
        return new AbstractSet<O>(){

            @Override
            public Iterator<O> iterator() {
                return new MapIterator(input.iterator(), functor);
            }

            @Override
            public boolean contains(Object o) {
                Object element = functor.deapply(o);
                return element == null ? false : input.contains(element);
            }

            @Override
            public int size() {
                return input.size();
            }
        };
    }

    public static <T> String toString(Iterable<T> iterable) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (T elem : iterable) {
            String elemStr = elem.toString();
            if (!first && !elemStr.isEmpty()) {
                builder.append(' ');
            }
            if (!elemStr.isEmpty()) {
                builder.append(elemStr);
            }
            first = false;
        }
        return builder.toString();
    }

    public static final <T> Comparator<? super Iterable<T>> lexicalOrder(final Comparator<? super T> elementComparator) {
        return new Comparator<Iterable<T>>(){

            @Override
            public int compare(Iterable<T> o1, Iterable<T> o2) {
                Iterator list2;
                Iterator list1 = o1 == null ? Collections.emptyList().iterator() : o1.iterator();
                Iterator iterator = list2 = o2 == null ? Collections.emptyList().iterator() : o2.iterator();
                while (list1.hasNext() || list2.hasNext()) {
                    if (!list1.hasNext()) {
                        return -1;
                    }
                    if (!list2.hasNext()) {
                        return 1;
                    }
                    int cmp = elementComparator.compare(list1.next(), list2.next());
                    if (cmp == 0) continue;
                    return cmp;
                }
                return 0;
            }
        };
    }

    private static class MapIterator<I, O>
    implements Iterator<O> {
        private final Iterator<? extends I> iter_;
        private final Functor<I, O> functor_;

        MapIterator(Iterator<? extends I> iter, Functor<I, O> functor) {
            this.iter_ = iter;
            this.functor_ = functor;
        }

        @Override
        public boolean hasNext() {
            return this.iter_.hasNext();
        }

        @Override
        public O next() {
            return this.functor_.apply(this.iter_.next());
        }

        @Override
        public void remove() {
            this.iter_.remove();
        }
    }

    public static interface FunctorEx<I, O>
    extends Functor<I, O> {
        public I deapply(Object var1);
    }

    public static interface Functor<I, O> {
        public O apply(I var1);
    }

    public static interface Transformation<I, O> {
        public O transform(I var1);
    }
}

