/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.concurrent.computation;

import org.semanticweb.elk.util.concurrent.computation.ConcurrentExecutor;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;
import org.semanticweb.elk.util.concurrent.computation.JobMonitor;
import org.semanticweb.elk.util.concurrent.computation.ProcessorFactory;

public class ConcurrentComputation<F extends ProcessorFactory<?>>
implements InterruptMonitor {
    protected final F processorFactory;
    protected final int maxWorkers;
    protected final ConcurrentExecutor executor;
    protected volatile boolean termination;
    protected final Runnable worker;
    protected JobMonitor jobMonitor;

    public ConcurrentComputation(F processorFactory, ConcurrentExecutor executor, int maxWorkers) {
        this.processorFactory = processorFactory;
        this.termination = false;
        this.worker = this.getWorker();
        this.executor = executor;
        this.maxWorkers = maxWorkers;
    }

    public synchronized boolean start() {
        this.termination = false;
        this.jobMonitor = this.executor.submit(this.worker, this.maxWorkers);
        return true;
    }

    protected synchronized void waitWorkers() throws InterruptedException {
        if (this.jobMonitor == null) {
            return;
        }
        this.jobMonitor.waitDone();
    }

    public synchronized void finish() throws InterruptedException {
        this.termination = true;
        this.waitWorkers();
        if (!this.isInterrupted()) {
            this.processorFactory.finish();
        }
    }

    @Override
    public boolean isInterrupted() {
        return this.processorFactory.isInterrupted();
    }

    Runnable getWorker() {
        return new Worker();
    }

    private class Worker
    implements Runnable {
        private RuntimeException workerException_ = null;

        private Worker() {
        }

        @Override
        public final void run() {
            Object inputProcessor = ConcurrentComputation.this.processorFactory.getEngine();
            try {
                do {
                    inputProcessor.process();
                } while (!ConcurrentComputation.this.termination && !ConcurrentComputation.this.isInterrupted());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable e) {
                this.workerException_ = new RuntimeException("Exception in worker thread: ", e);
            }
            finally {
                if (this.workerException_ != null) {
                    throw this.workerException_;
                }
                inputProcessor.finish();
            }
        }
    }
}

