package spa.lyh.cn.token_utils.utils;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class AESUtil {
    private static String gcm256algorithm = "AES/GCM/NoPadding";


    public static String getKey() {
        KeyGenerator generator;
        String gcmSecretKey = null;

        try {
            generator = KeyGenerator.getInstance("AES");
            generator.init(128);
            SecretKey secretKey = generator.generateKey();
            gcmSecretKey = Base64Utils.encode(secretKey.getEncoded());
        } catch (Exception var3) {
            Exception e = var3;
            e.printStackTrace();
        }

        return gcmSecretKey;
    }

    public static byte[] AEGCMEncrypt(String content, String keyStr) {
        try {
            if (content != null && !content.equals("") && keyStr != null && !keyStr.equals("")) {
                SecretKey secretKey = new SecretKeySpec(Base64Utils.decode(keyStr), "AES");
                Cipher cipher = Cipher.getInstance(gcm256algorithm);
                cipher.init(1, secretKey);
                byte[] iv = cipher.getIV();

                assert iv.length == 12;

                byte[] encryptData = cipher.doFinal(content.getBytes());

                assert encryptData.length == content.getBytes().length + 16;

                byte[] message = new byte[12 + content.getBytes().length + 16];
                System.arraycopy(iv, 0, message, 0, 12);
                System.arraycopy(encryptData, 0, message, 12, encryptData.length);
                return message;
            } else {
                throw new Exception("AESGCM256加密异常,检查文本或密钥");
            }
        } catch (Exception var7) {
            Exception e = var7;
            e.printStackTrace();
            return null;
        }
    }
}
