package spa.lyh.cn.token_utils.utils;

import android.os.Build;
import android.util.Base64;

public class Base64Utils {

    public static byte[] decode(String base64) throws Exception {
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.O){
            return java.util.Base64.getDecoder().decode(base64.getBytes());
        }else{
            return android.util.Base64.decode(base64.getBytes(),Base64.NO_WRAP);
        }
    }

    public static String encode(byte[] bytes) throws Exception {
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.O){
            return new String(java.util.Base64.getEncoder().encode(bytes));
        }else{
            return android.util.Base64.encodeToString(bytes, Base64.NO_WRAP);
        }
    }
}
