/*
 * Decompiled with CFR 0.152.
 */
package skin.support.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.util.AttributeSet;
import androidx.cardview.widget.CardView;
import skin.support.cardview.R;
import skin.support.content.res.SkinCompatResources;
import skin.support.widget.SkinCompatHelper;
import skin.support.widget.SkinCompatSupportable;

public class SkinCompatCardView
extends CardView
implements SkinCompatSupportable {
    private static final int[] COLOR_BACKGROUND_ATTR = new int[]{0x1010031};
    private int mThemeColorBackgroundResId = 0;
    private int mBackgroundColorResId = 0;

    public SkinCompatCardView(Context context) {
        this(context, null);
    }

    public SkinCompatCardView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SkinCompatCardView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CardView, defStyleAttr, R.style.CardView);
        if (a.hasValue(R.styleable.CardView_cardBackgroundColor)) {
            this.mBackgroundColorResId = a.getResourceId(R.styleable.CardView_cardBackgroundColor, 0);
        } else {
            TypedArray aa = this.getContext().obtainStyledAttributes(COLOR_BACKGROUND_ATTR);
            this.mThemeColorBackgroundResId = aa.getResourceId(0, 0);
            aa.recycle();
        }
        a.recycle();
        this.applyBackgroundColorResource();
    }

    private void applyBackgroundColorResource() {
        this.mBackgroundColorResId = SkinCompatHelper.checkResourceId((int)this.mBackgroundColorResId);
        this.mThemeColorBackgroundResId = SkinCompatHelper.checkResourceId((int)this.mThemeColorBackgroundResId);
        if (this.mBackgroundColorResId != 0) {
            ColorStateList backgroundColor = SkinCompatResources.getColorStateList((Context)this.getContext(), (int)this.mBackgroundColorResId);
            this.setCardBackgroundColor(backgroundColor);
        } else if (this.mThemeColorBackgroundResId != 0) {
            int themeColorBackground = SkinCompatResources.getColor((Context)this.getContext(), (int)this.mThemeColorBackgroundResId);
            float[] hsv = new float[3];
            Color.colorToHSV((int)themeColorBackground, (float[])hsv);
            ColorStateList backgroundColor = ColorStateList.valueOf((int)(hsv[2] > 0.5f ? this.getResources().getColor(R.color.cardview_light_background) : this.getResources().getColor(R.color.cardview_dark_background)));
            this.setCardBackgroundColor(backgroundColor);
        }
    }

    public void applySkin() {
        this.applyBackgroundColorResource();
    }
}

