/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.listener;

import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RealtimeListener
extends WebSocketListener {
    private static final Logger log = LoggerFactory.getLogger(RealtimeListener.class);

    protected abstract void onOpen(WebSocket var1);

    protected abstract void onMessage(ByteString var1);

    protected abstract void onMessage(String var1);

    protected abstract void onFailure();

    public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
        log.info("WebSocket Opened: " + response.message());
        this.onOpen(webSocket);
    }

    public void onMessage(@NotNull WebSocket webSocket, @NotNull ByteString bytes) {
        log.info("Receive Byte Message: " + bytes.toString());
        this.onMessage(bytes);
    }

    public void onMessage(@NotNull WebSocket webSocket, @NotNull String text) {
        log.info("Receive String Message: " + text);
        this.onMessage(text);
    }

    public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
        log.error("WebSocket Error: ", t);
    }

    public void onClosing(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
    }

    public void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
        log.info("WebSocket Closed: " + reason);
    }
}

