/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.platform.lingyi.chat;

import com.alibaba.fastjson2.JSON;
import io.github.lnyocly.ai4j.config.LingyiConfig;
import io.github.lnyocly.ai4j.convert.chat.ParameterConvert;
import io.github.lnyocly.ai4j.convert.chat.ResultConvert;
import io.github.lnyocly.ai4j.listener.SseListener;
import io.github.lnyocly.ai4j.platform.lingyi.chat.entity.LingyiChatCompletion;
import io.github.lnyocly.ai4j.platform.lingyi.chat.entity.LingyiChatCompletionResponse;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.ChatCompletion;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.ChatCompletionResponse;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.ChatMessage;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.Choice;
import io.github.lnyocly.ai4j.platform.openai.tool.Tool;
import io.github.lnyocly.ai4j.platform.openai.tool.ToolCall;
import io.github.lnyocly.ai4j.platform.openai.usage.Usage;
import io.github.lnyocly.ai4j.service.Configuration;
import io.github.lnyocly.ai4j.service.IChatService;
import io.github.lnyocly.ai4j.utils.ToolUtil;
import io.github.lnyocly.ai4j.utils.ValidateUtil;
import java.util.ArrayList;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LingyiChatService
implements IChatService,
ParameterConvert<LingyiChatCompletion>,
ResultConvert<LingyiChatCompletionResponse> {
    private final LingyiConfig lingyiConfig;
    private final OkHttpClient okHttpClient;
    private final EventSource.Factory factory;

    public LingyiChatService(Configuration configuration) {
        this.lingyiConfig = configuration.getLingyiConfig();
        this.okHttpClient = configuration.getOkHttpClient();
        this.factory = configuration.createRequestFactory();
    }

    @Override
    public LingyiChatCompletion convertChatCompletionObject(ChatCompletion chatCompletion) {
        LingyiChatCompletion lingyiChatCompletion = new LingyiChatCompletion();
        lingyiChatCompletion.setModel(chatCompletion.getModel());
        lingyiChatCompletion.setMessages(chatCompletion.getMessages());
        lingyiChatCompletion.setTools(chatCompletion.getTools());
        lingyiChatCompletion.setFunctions(chatCompletion.getFunctions());
        lingyiChatCompletion.setToolChoice(chatCompletion.getToolChoice());
        lingyiChatCompletion.setTemperature(chatCompletion.getTemperature());
        lingyiChatCompletion.setTopP(chatCompletion.getTopP());
        lingyiChatCompletion.setStream(chatCompletion.getStream());
        lingyiChatCompletion.setMaxTokens(chatCompletion.getMaxTokens());
        return lingyiChatCompletion;
    }

    @Override
    public EventSourceListener convertEventSource(final SseListener eventSourceListener) {
        return new EventSourceListener(){

            public void onOpen(@NotNull EventSource eventSource, @NotNull Response response) {
                eventSourceListener.onOpen(eventSource, response);
            }

            public void onFailure(@NotNull EventSource eventSource, @Nullable Throwable t, @Nullable Response response) {
                eventSourceListener.onFailure(eventSource, t, response);
            }

            public void onEvent(@NotNull EventSource eventSource, @Nullable String id, @Nullable String type, @NotNull String data) {
                if ("[DONE]".equalsIgnoreCase(data)) {
                    eventSourceListener.onEvent(eventSource, id, type, data);
                    return;
                }
                LingyiChatCompletionResponse chatCompletionResponse = (LingyiChatCompletionResponse)JSON.parseObject((String)data, LingyiChatCompletionResponse.class);
                ChatCompletionResponse response = LingyiChatService.this.convertChatCompletionResponse(chatCompletionResponse);
                eventSourceListener.onEvent(eventSource, id, type, JSON.toJSONString((Object)response));
            }

            public void onClosed(@NotNull EventSource eventSource) {
                eventSourceListener.onClosed(eventSource);
            }
        };
    }

    @Override
    public ChatCompletionResponse convertChatCompletionResponse(LingyiChatCompletionResponse lingyiChatCompletionResponse) {
        ChatCompletionResponse chatCompletionResponse = new ChatCompletionResponse();
        chatCompletionResponse.setId(lingyiChatCompletionResponse.getId());
        chatCompletionResponse.setObject(lingyiChatCompletionResponse.getObject());
        chatCompletionResponse.setCreated(lingyiChatCompletionResponse.getCreated());
        chatCompletionResponse.setModel(lingyiChatCompletionResponse.getModel());
        chatCompletionResponse.setChoices(lingyiChatCompletionResponse.getChoices());
        chatCompletionResponse.setUsage(lingyiChatCompletionResponse.getUsage());
        return chatCompletionResponse;
    }

    @Override
    public ChatCompletionResponse chatCompletion(String baseUrl, String apiKey, ChatCompletion chatCompletion) throws Exception {
        if (baseUrl == null || "".equals(baseUrl)) {
            baseUrl = this.lingyiConfig.getApiHost();
        }
        if (apiKey == null || "".equals(apiKey)) {
            apiKey = this.lingyiConfig.getApiKey();
        }
        chatCompletion.setStream(false);
        chatCompletion.setStreamOptions(null);
        LingyiChatCompletion lingyiChatCompletion = this.convertChatCompletionObject(chatCompletion);
        if (lingyiChatCompletion.getFunctions() != null && !lingyiChatCompletion.getFunctions().isEmpty()) {
            List<Tool> tools = ToolUtil.getAllFunctionTools(lingyiChatCompletion.getFunctions());
            lingyiChatCompletion.setTools(tools);
        }
        Usage allUsage = new Usage();
        String finishReason = "first";
        while ("first".equals(finishReason) || "tool_calls".equals(finishReason)) {
            finishReason = null;
            String requestString = JSON.toJSONString((Object)lingyiChatCompletion);
            Request request = new Request.Builder().header("Authorization", "Bearer " + apiKey).url(ValidateUtil.concatUrl(baseUrl, this.lingyiConfig.getChatCompletionUrl())).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)requestString)).build();
            Response execute = this.okHttpClient.newCall(request).execute();
            if (!execute.isSuccessful() || execute.body() == null) continue;
            LingyiChatCompletionResponse lingyiChatCompletionResponse = (LingyiChatCompletionResponse)JSON.parseObject((String)execute.body().string(), LingyiChatCompletionResponse.class);
            Choice choice = lingyiChatCompletionResponse.getChoices().get(0);
            finishReason = choice.getFinishReason();
            Usage usage = lingyiChatCompletionResponse.getUsage();
            allUsage.setCompletionTokens(allUsage.getCompletionTokens() + usage.getCompletionTokens());
            allUsage.setTotalTokens(allUsage.getTotalTokens() + usage.getTotalTokens());
            allUsage.setPromptTokens(allUsage.getPromptTokens() + usage.getPromptTokens());
            if ("tool_calls".equals(finishReason)) {
                ChatMessage message = choice.getMessage();
                List<ToolCall> toolCalls = message.getToolCalls();
                ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>(lingyiChatCompletion.getMessages());
                messages.add(message);
                for (ToolCall toolCall : toolCalls) {
                    String functionName = toolCall.getFunction().getName();
                    String arguments = toolCall.getFunction().getArguments();
                    String functionResponse = ToolUtil.invoke(functionName, arguments);
                    messages.add(ChatMessage.withTool(functionResponse, toolCall.getId()));
                }
                lingyiChatCompletion.setMessages(messages);
                continue;
            }
            lingyiChatCompletionResponse.setUsage(allUsage);
            chatCompletion.setMessages(lingyiChatCompletion.getMessages());
            chatCompletion.setTools(lingyiChatCompletion.getTools());
            return this.convertChatCompletionResponse(lingyiChatCompletionResponse);
        }
        return null;
    }

    @Override
    public ChatCompletionResponse chatCompletion(ChatCompletion chatCompletion) throws Exception {
        return this.chatCompletion(null, null, chatCompletion);
    }

    @Override
    public void chatCompletionStream(String baseUrl, String apiKey, ChatCompletion chatCompletion, SseListener eventSourceListener) throws Exception {
        if (baseUrl == null || "".equals(baseUrl)) {
            baseUrl = this.lingyiConfig.getApiHost();
        }
        if (apiKey == null || "".equals(apiKey)) {
            apiKey = this.lingyiConfig.getApiKey();
        }
        chatCompletion.setStream(true);
        LingyiChatCompletion lingyiChatCompletion = this.convertChatCompletionObject(chatCompletion);
        if (lingyiChatCompletion.getFunctions() != null && !lingyiChatCompletion.getFunctions().isEmpty()) {
            List<Tool> tools = ToolUtil.getAllFunctionTools(lingyiChatCompletion.getFunctions());
            lingyiChatCompletion.setTools(tools);
        }
        String finishReason = "first";
        while ("first".equals(finishReason) || "tool_calls".equals(finishReason)) {
            finishReason = null;
            String jsonString = JSON.toJSONString((Object)lingyiChatCompletion);
            Request request = new Request.Builder().header("Authorization", "Bearer " + apiKey).url(ValidateUtil.concatUrl(baseUrl, this.lingyiConfig.getChatCompletionUrl())).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonString)).build();
            this.factory.newEventSource(request, this.convertEventSource(eventSourceListener));
            eventSourceListener.getCountDownLatch().await();
            finishReason = eventSourceListener.getFinishReason();
            List<ToolCall> toolCalls = eventSourceListener.getToolCalls();
            if (!"tool_calls".equals(finishReason) || toolCalls.isEmpty()) continue;
            ChatMessage responseMessage = ChatMessage.withAssistant(eventSourceListener.getToolCalls());
            ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>(lingyiChatCompletion.getMessages());
            messages.add(responseMessage);
            for (ToolCall toolCall : toolCalls) {
                String functionName = toolCall.getFunction().getName();
                String arguments = toolCall.getFunction().getArguments();
                String functionResponse = ToolUtil.invoke(functionName, arguments);
                messages.add(ChatMessage.withTool(functionResponse, toolCall.getId()));
            }
            eventSourceListener.setToolCalls(new ArrayList<ToolCall>());
            eventSourceListener.setToolCall(null);
            lingyiChatCompletion.setMessages(messages);
        }
        chatCompletion.setMessages(lingyiChatCompletion.getMessages());
        chatCompletion.setTools(lingyiChatCompletion.getTools());
    }

    @Override
    public void chatCompletionStream(ChatCompletion chatCompletion, SseListener eventSourceListener) throws Exception {
        this.chatCompletionStream(null, null, chatCompletion, eventSourceListener);
    }
}

