/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.platform.lingyi.chat.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.ChatMessage;
import io.github.lnyocly.ai4j.platform.openai.tool.Tool;
import java.util.List;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LingyiChatCompletion {
    @NonNull
    private String model;
    @NonNull
    private List<ChatMessage> messages;
    private List<Tool> tools;
    @JsonIgnore
    private List<String> functions;
    @JsonProperty(value="tool_choice")
    private String toolChoice;
    private Float temperature;
    @JsonProperty(value="top_p")
    private Float topP;
    private Boolean stream = false;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;

    private static Float $default$temperature() {
        return Float.valueOf(1.0f);
    }

    private static Float $default$topP() {
        return Float.valueOf(1.0f);
    }

    public static LingyiChatCompletionBuilder builder() {
        return new LingyiChatCompletionBuilder();
    }

    public LingyiChatCompletionBuilder toBuilder() {
        return new LingyiChatCompletionBuilder().model(this.model).messages(this.messages).tools(this.tools).functions(this.functions).toolChoice(this.toolChoice).temperature(this.temperature).topP(this.topP).stream(this.stream).maxTokens(this.maxTokens);
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    @NonNull
    public List<ChatMessage> getMessages() {
        return this.messages;
    }

    public List<Tool> getTools() {
        return this.tools;
    }

    public List<String> getFunctions() {
        return this.functions;
    }

    public String getToolChoice() {
        return this.toolChoice;
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public Float getTopP() {
        return this.topP;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setModel(@NonNull String model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.model = model;
    }

    public void setMessages(@NonNull List<ChatMessage> messages) {
        if (messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
        this.messages = messages;
    }

    public void setTools(List<Tool> tools) {
        this.tools = tools;
    }

    @JsonIgnore
    public void setFunctions(List<String> functions) {
        this.functions = functions;
    }

    @JsonProperty(value="tool_choice")
    public void setToolChoice(String toolChoice) {
        this.toolChoice = toolChoice;
    }

    public void setTemperature(Float temperature) {
        this.temperature = temperature;
    }

    @JsonProperty(value="top_p")
    public void setTopP(Float topP) {
        this.topP = topP;
    }

    public void setStream(Boolean stream) {
        this.stream = stream;
    }

    @JsonProperty(value="max_tokens")
    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LingyiChatCompletion)) {
            return false;
        }
        LingyiChatCompletion other = (LingyiChatCompletion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$temperature = this.getTemperature();
        Float other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        Float this$topP = this.getTopP();
        Float other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Boolean this$stream = this.getStream();
        Boolean other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !((Object)this$stream).equals(other$stream)) {
            return false;
        }
        Integer this$maxTokens = this.getMaxTokens();
        Integer other$maxTokens = other.getMaxTokens();
        if (this$maxTokens == null ? other$maxTokens != null : !((Object)this$maxTokens).equals(other$maxTokens)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<ChatMessage> this$messages = this.getMessages();
        List<ChatMessage> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        List<Tool> this$tools = this.getTools();
        List<Tool> other$tools = other.getTools();
        if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
            return false;
        }
        List<String> this$functions = this.getFunctions();
        List<String> other$functions = other.getFunctions();
        if (this$functions == null ? other$functions != null : !((Object)this$functions).equals(other$functions)) {
            return false;
        }
        String this$toolChoice = this.getToolChoice();
        String other$toolChoice = other.getToolChoice();
        return !(this$toolChoice == null ? other$toolChoice != null : !this$toolChoice.equals(other$toolChoice));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LingyiChatCompletion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        Float $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Boolean $stream = this.getStream();
        result = result * 59 + ($stream == null ? 43 : ((Object)$stream).hashCode());
        Integer $maxTokens = this.getMaxTokens();
        result = result * 59 + ($maxTokens == null ? 43 : ((Object)$maxTokens).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<ChatMessage> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        List<Tool> $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        List<String> $functions = this.getFunctions();
        result = result * 59 + ($functions == null ? 43 : ((Object)$functions).hashCode());
        String $toolChoice = this.getToolChoice();
        result = result * 59 + ($toolChoice == null ? 43 : $toolChoice.hashCode());
        return result;
    }

    public String toString() {
        return "LingyiChatCompletion(model=" + this.getModel() + ", messages=" + this.getMessages() + ", tools=" + this.getTools() + ", functions=" + this.getFunctions() + ", toolChoice=" + this.getToolChoice() + ", temperature=" + this.getTemperature() + ", topP=" + this.getTopP() + ", stream=" + this.getStream() + ", maxTokens=" + this.getMaxTokens() + ")";
    }

    public LingyiChatCompletion() {
        this.temperature = LingyiChatCompletion.$default$temperature();
        this.topP = LingyiChatCompletion.$default$topP();
    }

    public LingyiChatCompletion(@NonNull String model, @NonNull List<ChatMessage> messages, List<Tool> tools, List<String> functions, String toolChoice, Float temperature, Float topP, Boolean stream, Integer maxTokens) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
        this.model = model;
        this.messages = messages;
        this.tools = tools;
        this.functions = functions;
        this.toolChoice = toolChoice;
        this.temperature = temperature;
        this.topP = topP;
        this.stream = stream;
        this.maxTokens = maxTokens;
    }

    public static class LingyiChatCompletionBuilder {
        private String model;
        private List<ChatMessage> messages;
        private List<Tool> tools;
        private List<String> functions;
        private String toolChoice;
        private boolean temperature$set;
        private Float temperature$value;
        private boolean topP$set;
        private Float topP$value;
        private Boolean stream;
        private Integer maxTokens;

        LingyiChatCompletionBuilder() {
        }

        public LingyiChatCompletionBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            return this;
        }

        public LingyiChatCompletionBuilder messages(@NonNull List<ChatMessage> messages) {
            if (messages == null) {
                throw new NullPointerException("messages is marked non-null but is null");
            }
            this.messages = messages;
            return this;
        }

        public LingyiChatCompletionBuilder tools(List<Tool> tools) {
            this.tools = tools;
            return this;
        }

        @JsonIgnore
        public LingyiChatCompletionBuilder functions(List<String> functions) {
            this.functions = functions;
            return this;
        }

        @JsonProperty(value="tool_choice")
        public LingyiChatCompletionBuilder toolChoice(String toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        public LingyiChatCompletionBuilder temperature(Float temperature) {
            this.temperature$value = temperature;
            this.temperature$set = true;
            return this;
        }

        @JsonProperty(value="top_p")
        public LingyiChatCompletionBuilder topP(Float topP) {
            this.topP$value = topP;
            this.topP$set = true;
            return this;
        }

        public LingyiChatCompletionBuilder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        @JsonProperty(value="max_tokens")
        public LingyiChatCompletionBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public LingyiChatCompletion build() {
            Float temperature$value = this.temperature$value;
            if (!this.temperature$set) {
                temperature$value = LingyiChatCompletion.$default$temperature();
            }
            Float topP$value = this.topP$value;
            if (!this.topP$set) {
                topP$value = LingyiChatCompletion.$default$topP();
            }
            return new LingyiChatCompletion(this.model, this.messages, this.tools, this.functions, this.toolChoice, temperature$value, topP$value, this.stream, this.maxTokens);
        }

        public String toString() {
            return "LingyiChatCompletion.LingyiChatCompletionBuilder(model=" + this.model + ", messages=" + this.messages + ", tools=" + this.tools + ", functions=" + this.functions + ", toolChoice=" + this.toolChoice + ", temperature$value=" + this.temperature$value + ", topP$value=" + this.topP$value + ", stream=" + this.stream + ", maxTokens=" + this.maxTokens + ")";
        }
    }
}

