/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.platform.moonshot.chat;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReader;
import io.github.lnyocly.ai4j.config.MoonshotConfig;
import io.github.lnyocly.ai4j.convert.chat.ParameterConvert;
import io.github.lnyocly.ai4j.convert.chat.ResultConvert;
import io.github.lnyocly.ai4j.listener.SseListener;
import io.github.lnyocly.ai4j.platform.moonshot.chat.entity.MoonshotChatCompletion;
import io.github.lnyocly.ai4j.platform.moonshot.chat.entity.MoonshotChatCompletionResponse;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.ChatCompletion;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.ChatCompletionResponse;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.ChatMessage;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.Choice;
import io.github.lnyocly.ai4j.platform.openai.tool.Tool;
import io.github.lnyocly.ai4j.platform.openai.tool.ToolCall;
import io.github.lnyocly.ai4j.platform.openai.usage.Usage;
import io.github.lnyocly.ai4j.service.Configuration;
import io.github.lnyocly.ai4j.service.IChatService;
import io.github.lnyocly.ai4j.utils.ToolUtil;
import io.github.lnyocly.ai4j.utils.ValidateUtil;
import java.util.ArrayList;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoonshotChatService
implements IChatService,
ParameterConvert<MoonshotChatCompletion>,
ResultConvert<MoonshotChatCompletionResponse> {
    private final MoonshotConfig moonshotConfig;
    private final OkHttpClient okHttpClient;
    private final EventSource.Factory factory;

    public MoonshotChatService(Configuration configuration) {
        this.moonshotConfig = configuration.getMoonshotConfig();
        this.okHttpClient = configuration.getOkHttpClient();
        this.factory = configuration.createRequestFactory();
    }

    @Override
    public MoonshotChatCompletion convertChatCompletionObject(ChatCompletion chatCompletion) {
        MoonshotChatCompletion moonshotChatCompletion = new MoonshotChatCompletion();
        moonshotChatCompletion.setModel(chatCompletion.getModel());
        moonshotChatCompletion.setMessages(chatCompletion.getMessages());
        moonshotChatCompletion.setFrequencyPenalty(chatCompletion.getFrequencyPenalty());
        moonshotChatCompletion.setMaxTokens(chatCompletion.getMaxTokens());
        moonshotChatCompletion.setPresencePenalty(chatCompletion.getPresencePenalty());
        moonshotChatCompletion.setResponseFormat(chatCompletion.getResponseFormat());
        moonshotChatCompletion.setStop(chatCompletion.getStop());
        moonshotChatCompletion.setStream(chatCompletion.getStream());
        moonshotChatCompletion.setTemperature(Float.valueOf(chatCompletion.getTemperature().floatValue() / 2.0f));
        moonshotChatCompletion.setTopP(chatCompletion.getTopP());
        moonshotChatCompletion.setTools(chatCompletion.getTools());
        moonshotChatCompletion.setFunctions(chatCompletion.getFunctions());
        moonshotChatCompletion.setToolChoice(chatCompletion.getToolChoice());
        return moonshotChatCompletion;
    }

    @Override
    public EventSourceListener convertEventSource(final SseListener eventSourceListener) {
        return new EventSourceListener(){

            public void onOpen(@NotNull EventSource eventSource, @NotNull Response response) {
                eventSourceListener.onOpen(eventSource, response);
            }

            public void onFailure(@NotNull EventSource eventSource, @Nullable Throwable t, @Nullable Response response) {
                eventSourceListener.onFailure(eventSource, t, response);
            }

            public void onEvent(@NotNull EventSource eventSource, @Nullable String id, @Nullable String type, @NotNull String data) {
                if ("[DONE]".equalsIgnoreCase(data)) {
                    eventSourceListener.onEvent(eventSource, id, type, data);
                    return;
                }
                MoonshotChatCompletionResponse chatCompletionResponse = (MoonshotChatCompletionResponse)JSON.parseObject((String)data, MoonshotChatCompletionResponse.class);
                ChatCompletionResponse response = MoonshotChatService.this.convertChatCompletionResponse(chatCompletionResponse);
                JSONObject object = (JSONObject)JSONPath.eval((String)data, (String)"$.choices[0].usage");
                if (object != null) {
                    Usage usage = (Usage)object.toJavaObject(Usage.class, new JSONReader.Feature[0]);
                    response.setUsage(usage);
                }
                eventSourceListener.onEvent(eventSource, id, type, JSON.toJSONString((Object)response));
            }

            public void onClosed(@NotNull EventSource eventSource) {
                eventSourceListener.onClosed(eventSource);
            }
        };
    }

    @Override
    public ChatCompletionResponse convertChatCompletionResponse(MoonshotChatCompletionResponse moonshotChatCompletionResponse) {
        ChatCompletionResponse chatCompletionResponse = new ChatCompletionResponse();
        chatCompletionResponse.setId(moonshotChatCompletionResponse.getId());
        chatCompletionResponse.setObject(moonshotChatCompletionResponse.getObject());
        chatCompletionResponse.setCreated(moonshotChatCompletionResponse.getCreated());
        chatCompletionResponse.setModel(moonshotChatCompletionResponse.getModel());
        chatCompletionResponse.setChoices(moonshotChatCompletionResponse.getChoices());
        chatCompletionResponse.setUsage(moonshotChatCompletionResponse.getUsage());
        return chatCompletionResponse;
    }

    @Override
    public ChatCompletionResponse chatCompletion(String baseUrl, String apiKey, ChatCompletion chatCompletion) throws Exception {
        if (baseUrl == null || "".equals(baseUrl)) {
            baseUrl = this.moonshotConfig.getApiHost();
        }
        if (apiKey == null || "".equals(apiKey)) {
            apiKey = this.moonshotConfig.getApiKey();
        }
        chatCompletion.setStream(false);
        MoonshotChatCompletion moonshotChatCompletion = this.convertChatCompletionObject(chatCompletion);
        if (moonshotChatCompletion.getFunctions() != null && !moonshotChatCompletion.getFunctions().isEmpty()) {
            List<Tool> tools = ToolUtil.getAllFunctionTools(moonshotChatCompletion.getFunctions());
            moonshotChatCompletion.setTools(tools);
        }
        Usage allUsage = new Usage();
        String finishReason = "first";
        while ("first".equals(finishReason) || "tool_calls".equals(finishReason)) {
            finishReason = null;
            String requestString = JSON.toJSONString((Object)moonshotChatCompletion);
            Request request = new Request.Builder().header("Authorization", "Bearer " + apiKey).url(ValidateUtil.concatUrl(baseUrl, this.moonshotConfig.getChatCompletionUrl())).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)requestString)).build();
            Response execute = this.okHttpClient.newCall(request).execute();
            if (!execute.isSuccessful() || execute.body() == null) continue;
            MoonshotChatCompletionResponse moonshotChatCompletionResponse = (MoonshotChatCompletionResponse)JSON.parseObject((String)execute.body().string(), MoonshotChatCompletionResponse.class);
            Choice choice = moonshotChatCompletionResponse.getChoices().get(0);
            finishReason = choice.getFinishReason();
            Usage usage = moonshotChatCompletionResponse.getUsage();
            allUsage.setCompletionTokens(allUsage.getCompletionTokens() + usage.getCompletionTokens());
            allUsage.setTotalTokens(allUsage.getTotalTokens() + usage.getTotalTokens());
            allUsage.setPromptTokens(allUsage.getPromptTokens() + usage.getPromptTokens());
            if ("tool_calls".equals(finishReason)) {
                ChatMessage message = choice.getMessage();
                List<ToolCall> toolCalls = message.getToolCalls();
                ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>(moonshotChatCompletion.getMessages());
                messages.add(message);
                for (ToolCall toolCall : toolCalls) {
                    String functionName = toolCall.getFunction().getName();
                    String arguments = toolCall.getFunction().getArguments();
                    String functionResponse = ToolUtil.invoke(functionName, arguments);
                    messages.add(ChatMessage.withTool(functionResponse, toolCall.getId()));
                }
                moonshotChatCompletion.setMessages(messages);
                continue;
            }
            moonshotChatCompletionResponse.setUsage(allUsage);
            chatCompletion.setMessages(moonshotChatCompletion.getMessages());
            chatCompletion.setTools(moonshotChatCompletion.getTools());
            return this.convertChatCompletionResponse(moonshotChatCompletionResponse);
        }
        return null;
    }

    @Override
    public ChatCompletionResponse chatCompletion(ChatCompletion chatCompletion) throws Exception {
        return this.chatCompletion(null, null, chatCompletion);
    }

    @Override
    public void chatCompletionStream(String baseUrl, String apiKey, ChatCompletion chatCompletion, SseListener eventSourceListener) throws Exception {
        if (baseUrl == null || "".equals(baseUrl)) {
            baseUrl = this.moonshotConfig.getApiHost();
        }
        if (apiKey == null || "".equals(apiKey)) {
            apiKey = this.moonshotConfig.getApiKey();
        }
        chatCompletion.setStream(true);
        MoonshotChatCompletion moonshotChatCompletion = this.convertChatCompletionObject(chatCompletion);
        if (moonshotChatCompletion.getFunctions() != null && !moonshotChatCompletion.getFunctions().isEmpty()) {
            List<Tool> tools = ToolUtil.getAllFunctionTools(moonshotChatCompletion.getFunctions());
            moonshotChatCompletion.setTools(tools);
        }
        String finishReason = "first";
        while ("first".equals(finishReason) || "tool_calls".equals(finishReason)) {
            finishReason = null;
            String jsonString = JSON.toJSONString((Object)moonshotChatCompletion);
            Request request = new Request.Builder().header("Authorization", "Bearer " + apiKey).url(ValidateUtil.concatUrl(baseUrl, this.moonshotConfig.getChatCompletionUrl())).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonString)).build();
            this.factory.newEventSource(request, this.convertEventSource(eventSourceListener));
            eventSourceListener.getCountDownLatch().await();
            finishReason = eventSourceListener.getFinishReason();
            List<ToolCall> toolCalls = eventSourceListener.getToolCalls();
            if (!"tool_calls".equals(finishReason) || toolCalls.isEmpty()) continue;
            ChatMessage responseMessage = ChatMessage.withAssistant(eventSourceListener.getToolCalls());
            ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>(moonshotChatCompletion.getMessages());
            messages.add(responseMessage);
            for (ToolCall toolCall : toolCalls) {
                String functionName = toolCall.getFunction().getName();
                String arguments = toolCall.getFunction().getArguments();
                String functionResponse = ToolUtil.invoke(functionName, arguments);
                messages.add(ChatMessage.withTool(functionResponse, toolCall.getId()));
            }
            eventSourceListener.setToolCalls(new ArrayList<ToolCall>());
            eventSourceListener.setToolCall(null);
            moonshotChatCompletion.setMessages(messages);
        }
        chatCompletion.setMessages(moonshotChatCompletion.getMessages());
        chatCompletion.setTools(moonshotChatCompletion.getTools());
    }

    @Override
    public void chatCompletionStream(ChatCompletion chatCompletion, SseListener eventSourceListener) throws Exception {
        this.chatCompletionStream(null, null, chatCompletion, eventSourceListener);
    }
}

