/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.platform.ollama.chat.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.github.lnyocly.ai4j.platform.ollama.chat.entity.OllamaMessage;
import io.github.lnyocly.ai4j.platform.ollama.chat.entity.OllamaOptions;
import io.github.lnyocly.ai4j.platform.openai.tool.Tool;
import java.util.List;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OllamaChatCompletion {
    @NonNull
    private String model;
    @NonNull
    private List<OllamaMessage> messages;
    private List<Tool> tools;
    @JsonIgnore
    private List<String> functions;
    private OllamaOptions options;
    private Boolean stream;

    public static OllamaChatCompletionBuilder builder() {
        return new OllamaChatCompletionBuilder();
    }

    public OllamaChatCompletionBuilder toBuilder() {
        return new OllamaChatCompletionBuilder().model(this.model).messages(this.messages).tools(this.tools).functions(this.functions).options(this.options).stream(this.stream);
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    @NonNull
    public List<OllamaMessage> getMessages() {
        return this.messages;
    }

    public List<Tool> getTools() {
        return this.tools;
    }

    public List<String> getFunctions() {
        return this.functions;
    }

    public OllamaOptions getOptions() {
        return this.options;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public void setModel(@NonNull String model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.model = model;
    }

    public void setMessages(@NonNull List<OllamaMessage> messages) {
        if (messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
        this.messages = messages;
    }

    public void setTools(List<Tool> tools) {
        this.tools = tools;
    }

    @JsonIgnore
    public void setFunctions(List<String> functions) {
        this.functions = functions;
    }

    public void setOptions(OllamaOptions options) {
        this.options = options;
    }

    public void setStream(Boolean stream) {
        this.stream = stream;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OllamaChatCompletion)) {
            return false;
        }
        OllamaChatCompletion other = (OllamaChatCompletion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$stream = this.getStream();
        Boolean other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !((Object)this$stream).equals(other$stream)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<OllamaMessage> this$messages = this.getMessages();
        List<OllamaMessage> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        List<Tool> this$tools = this.getTools();
        List<Tool> other$tools = other.getTools();
        if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
            return false;
        }
        List<String> this$functions = this.getFunctions();
        List<String> other$functions = other.getFunctions();
        if (this$functions == null ? other$functions != null : !((Object)this$functions).equals(other$functions)) {
            return false;
        }
        OllamaOptions this$options = this.getOptions();
        OllamaOptions other$options = other.getOptions();
        return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OllamaChatCompletion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $stream = this.getStream();
        result = result * 59 + ($stream == null ? 43 : ((Object)$stream).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<OllamaMessage> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        List<Tool> $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        List<String> $functions = this.getFunctions();
        result = result * 59 + ($functions == null ? 43 : ((Object)$functions).hashCode());
        OllamaOptions $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        return result;
    }

    public String toString() {
        return "OllamaChatCompletion(model=" + this.getModel() + ", messages=" + this.getMessages() + ", tools=" + this.getTools() + ", functions=" + this.getFunctions() + ", options=" + this.getOptions() + ", stream=" + this.getStream() + ")";
    }

    public OllamaChatCompletion() {
    }

    public OllamaChatCompletion(@NonNull String model, @NonNull List<OllamaMessage> messages, List<Tool> tools, List<String> functions, OllamaOptions options, Boolean stream) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
        this.model = model;
        this.messages = messages;
        this.tools = tools;
        this.functions = functions;
        this.options = options;
        this.stream = stream;
    }

    public static class OllamaChatCompletionBuilder {
        private String model;
        private List<OllamaMessage> messages;
        private List<Tool> tools;
        private List<String> functions;
        private OllamaOptions options;
        private Boolean stream;

        OllamaChatCompletionBuilder() {
        }

        public OllamaChatCompletionBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            return this;
        }

        public OllamaChatCompletionBuilder messages(@NonNull List<OllamaMessage> messages) {
            if (messages == null) {
                throw new NullPointerException("messages is marked non-null but is null");
            }
            this.messages = messages;
            return this;
        }

        public OllamaChatCompletionBuilder tools(List<Tool> tools) {
            this.tools = tools;
            return this;
        }

        @JsonIgnore
        public OllamaChatCompletionBuilder functions(List<String> functions) {
            this.functions = functions;
            return this;
        }

        public OllamaChatCompletionBuilder options(OllamaOptions options) {
            this.options = options;
            return this;
        }

        public OllamaChatCompletionBuilder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        public OllamaChatCompletion build() {
            return new OllamaChatCompletion(this.model, this.messages, this.tools, this.functions, this.options, this.stream);
        }

        public String toString() {
            return "OllamaChatCompletion.OllamaChatCompletionBuilder(model=" + this.model + ", messages=" + this.messages + ", tools=" + this.tools + ", functions=" + this.functions + ", options=" + this.options + ", stream=" + this.stream + ")";
        }
    }
}

