/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.platform.openai.audio;

import com.alibaba.fastjson2.JSON;
import io.github.lnyocly.ai4j.config.OpenAiConfig;
import io.github.lnyocly.ai4j.platform.openai.audio.entity.TextToSpeech;
import io.github.lnyocly.ai4j.platform.openai.audio.entity.Transcription;
import io.github.lnyocly.ai4j.platform.openai.audio.entity.TranscriptionResponse;
import io.github.lnyocly.ai4j.platform.openai.audio.entity.Translation;
import io.github.lnyocly.ai4j.platform.openai.audio.entity.TranslationResponse;
import io.github.lnyocly.ai4j.service.Configuration;
import io.github.lnyocly.ai4j.service.IAudioService;
import io.github.lnyocly.ai4j.utils.ValidateUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;

public class OpenAiAudioService
implements IAudioService {
    private final OpenAiConfig openAiConfig;
    private final OkHttpClient okHttpClient;

    public OpenAiAudioService(Configuration configuration) {
        this.openAiConfig = configuration.getOpenAiConfig();
        this.okHttpClient = configuration.getOkHttpClient();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream textToSpeech(String baseUrl, String apiKey, TextToSpeech textToSpeech) {
        if (baseUrl == null || "".equals(baseUrl)) {
            baseUrl = this.openAiConfig.getApiHost();
        }
        if (apiKey == null || "".equals(apiKey)) {
            apiKey = this.openAiConfig.getApiKey();
        }
        String requestString = JSON.toJSONString((Object)textToSpeech);
        Request request = new Request.Builder().header("Authorization", "Bearer " + apiKey).url(ValidateUtil.concatUrl(baseUrl, this.openAiConfig.getSpeechUrl())).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)requestString)).build();
        try (Response response = this.okHttpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            ResponseBody responseBody = response.body();
            if (responseBody == null) return null;
            InputStream inputStream = responseBody.byteStream();
            return inputStream;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public InputStream textToSpeech(TextToSpeech textToSpeech) {
        return this.textToSpeech(null, null, textToSpeech);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TranscriptionResponse transcription(String baseUrl, String apiKey, Transcription transcription) {
        if (baseUrl == null || "".equals(baseUrl)) {
            baseUrl = this.openAiConfig.getApiHost();
        }
        if (apiKey == null || "".equals(apiKey)) {
            apiKey = this.openAiConfig.getApiKey();
        }
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", transcription.getFile().getName(), RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)transcription.getFile())).addFormDataPart("model", transcription.getModel()).addFormDataPart("temperature", String.valueOf(transcription.getTemperature()));
        if (StringUtils.isNotBlank((CharSequence)transcription.getLanguage())) {
            builder.addFormDataPart("language", transcription.getLanguage());
        }
        if (StringUtils.isNotBlank((CharSequence)transcription.getPrompt())) {
            builder.addFormDataPart("prompt", transcription.getPrompt());
        }
        if (StringUtils.isNotBlank((CharSequence)transcription.getResponseFormat())) {
            builder.addFormDataPart("response_format", transcription.getResponseFormat());
        }
        MultipartBody multipartBody = builder.build();
        Request request = new Request.Builder().header("Authorization", "Bearer " + apiKey).url(ValidateUtil.concatUrl(baseUrl, this.openAiConfig.getTranscriptionUrl())).post((RequestBody)multipartBody).build();
        try (Response response = this.okHttpClient.newCall(request).execute();){
            TranscriptionResponse transcriptionResponse2;
            if (!response.isSuccessful()) return null;
            String res = response.body().string();
            TranscriptionResponse transcriptionResponse = transcriptionResponse2 = (TranscriptionResponse)JSON.parseObject((String)res, TranscriptionResponse.class);
            return transcriptionResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public TranscriptionResponse transcription(Transcription transcription) {
        return this.transcription(null, null, transcription);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TranslationResponse translation(String baseUrl, String apiKey, Translation translation) {
        if (baseUrl == null || "".equals(baseUrl)) {
            baseUrl = this.openAiConfig.getApiHost();
        }
        if (apiKey == null || "".equals(apiKey)) {
            apiKey = this.openAiConfig.getApiKey();
        }
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", translation.getFile().getName(), RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)translation.getFile())).addFormDataPart("model", translation.getModel()).addFormDataPart("temperature", String.valueOf(translation.getTemperature()));
        if (StringUtils.isNotBlank((CharSequence)translation.getPrompt())) {
            builder.addFormDataPart("prompt", translation.getPrompt());
        }
        if (StringUtils.isNotBlank((CharSequence)translation.getResponseFormat())) {
            builder.addFormDataPart("response_format", translation.getResponseFormat());
        }
        MultipartBody multipartBody = builder.build();
        Request request = new Request.Builder().header("Authorization", "Bearer " + apiKey).url(ValidateUtil.concatUrl(baseUrl, this.openAiConfig.getTranslationUrl())).post((RequestBody)multipartBody).build();
        try (Response response = this.okHttpClient.newCall(request).execute();){
            TranslationResponse translationResponse2;
            if (!response.isSuccessful()) return null;
            String res = response.body().string();
            TranslationResponse translationResponse = translationResponse2 = (TranslationResponse)JSON.parseObject((String)res, TranslationResponse.class);
            return translationResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public TranslationResponse translation(Translation translation) {
        return this.translation(null, null, translation);
    }
}

