/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.platform.openai.audio.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.lnyocly.ai4j.platform.openai.audio.enums.WhisperEnum;
import java.io.File;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Translation {
    @NonNull
    private File file;
    @NonNull
    private String model;
    private String prompt;
    @JsonProperty(value="response_format")
    private String responseFormat;
    private Double temperature;

    public void setFile(@NonNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("file is required");
        }
        String[] allowedFormats = new String[]{"flac", "mp3", "mp4", "mpeg", "mpga", "m4a", "ogg", "wav", "webm"};
        String fileName = file.getName().toLowerCase();
        boolean isValidFormat = false;
        for (String format : allowedFormats) {
            if (!fileName.endsWith("." + format)) continue;
            isValidFormat = true;
            break;
        }
        if (!isValidFormat) {
            throw new IllegalArgumentException("Invalid file format. Allowed formats are: flac, mp3, mp4, mpeg, mpga, m4a, ogg, wav, webm.");
        }
        this.file = file;
    }

    private static String $default$model() {
        return "whisper-1";
    }

    private static String $default$responseFormat() {
        return WhisperEnum.ResponseFormat.JSON.getValue();
    }

    private static Double $default$temperature() {
        return 0.0;
    }

    public static TranslationBuilder builder() {
        return new TranslationBuilder();
    }

    @NonNull
    public File getFile() {
        return this.file;
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public String getResponseFormat() {
        return this.responseFormat;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setModel(@NonNull String model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.model = model;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    @JsonProperty(value="response_format")
    public void setResponseFormat(String responseFormat) {
        this.responseFormat = responseFormat;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Translation)) {
            return false;
        }
        Translation other = (Translation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$temperature = this.getTemperature();
        Double other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$prompt = this.getPrompt();
        String other$prompt = other.getPrompt();
        if (this$prompt == null ? other$prompt != null : !this$prompt.equals(other$prompt)) {
            return false;
        }
        String this$responseFormat = this.getResponseFormat();
        String other$responseFormat = other.getResponseFormat();
        return !(this$responseFormat == null ? other$responseFormat != null : !this$responseFormat.equals(other$responseFormat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Translation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $prompt = this.getPrompt();
        result = result * 59 + ($prompt == null ? 43 : $prompt.hashCode());
        String $responseFormat = this.getResponseFormat();
        result = result * 59 + ($responseFormat == null ? 43 : $responseFormat.hashCode());
        return result;
    }

    public String toString() {
        return "Translation(file=" + this.getFile() + ", model=" + this.getModel() + ", prompt=" + this.getPrompt() + ", responseFormat=" + this.getResponseFormat() + ", temperature=" + this.getTemperature() + ")";
    }

    public Translation(@NonNull File file, @NonNull String model, String prompt, String responseFormat, Double temperature) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.file = file;
        this.model = model;
        this.prompt = prompt;
        this.responseFormat = responseFormat;
        this.temperature = temperature;
    }

    public Translation() {
        this.model = Translation.$default$model();
        this.responseFormat = Translation.$default$responseFormat();
        this.temperature = Translation.$default$temperature();
    }

    public static class TranslationBuilder {
        private boolean model$set;
        private String model$value;
        private String prompt;
        private boolean responseFormat$set;
        private String responseFormat$value;
        private boolean temperature$set;
        private Double temperature$value;
        private File file;

        public TranslationBuilder content(File file) {
            if (file == null) {
                throw new IllegalArgumentException("file is required");
            }
            String[] allowedFormats = new String[]{"flac", "mp3", "mp4", "mpeg", "mpga", "m4a", "ogg", "wav", "webm"};
            String fileName = file.getName().toLowerCase();
            boolean isValidFormat = false;
            for (String format : allowedFormats) {
                if (!fileName.endsWith("." + format)) continue;
                isValidFormat = true;
                break;
            }
            if (!isValidFormat) {
                throw new IllegalArgumentException("Invalid file format. Allowed formats are: flac, mp3, mp4, mpeg, mpga, m4a, ogg, wav, webm.");
            }
            this.file = file;
            return this;
        }

        TranslationBuilder() {
        }

        public TranslationBuilder file(@NonNull File file) {
            if (file == null) {
                throw new NullPointerException("file is marked non-null but is null");
            }
            this.file = file;
            return this;
        }

        public TranslationBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model$value = model;
            this.model$set = true;
            return this;
        }

        public TranslationBuilder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        @JsonProperty(value="response_format")
        public TranslationBuilder responseFormat(String responseFormat) {
            this.responseFormat$value = responseFormat;
            this.responseFormat$set = true;
            return this;
        }

        public TranslationBuilder temperature(Double temperature) {
            this.temperature$value = temperature;
            this.temperature$set = true;
            return this;
        }

        public Translation build() {
            String model$value = this.model$value;
            if (!this.model$set) {
                model$value = Translation.$default$model();
            }
            String responseFormat$value = this.responseFormat$value;
            if (!this.responseFormat$set) {
                responseFormat$value = Translation.$default$responseFormat();
            }
            Double temperature$value = this.temperature$value;
            if (!this.temperature$set) {
                temperature$value = Translation.$default$temperature();
            }
            return new Translation(this.file, model$value, this.prompt, responseFormat$value, temperature$value);
        }

        public String toString() {
            return "Translation.TranslationBuilder(file=" + this.file + ", model$value=" + this.model$value + ", prompt=" + this.prompt + ", responseFormat$value=" + this.responseFormat$value + ", temperature$value=" + this.temperature$value + ")";
        }
    }
}

