/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.platform.openai.embedding;

import com.alibaba.fastjson2.JSON;
import io.github.lnyocly.ai4j.config.OpenAiConfig;
import io.github.lnyocly.ai4j.platform.openai.embedding.entity.Embedding;
import io.github.lnyocly.ai4j.platform.openai.embedding.entity.EmbeddingResponse;
import io.github.lnyocly.ai4j.service.Configuration;
import io.github.lnyocly.ai4j.service.IEmbeddingService;
import io.github.lnyocly.ai4j.utils.ValidateUtil;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OpenAiEmbeddingService
implements IEmbeddingService {
    private final OpenAiConfig openAiConfig;
    private final OkHttpClient okHttpClient;

    public OpenAiEmbeddingService(Configuration configuration) {
        this.openAiConfig = configuration.getOpenAiConfig();
        this.okHttpClient = configuration.getOkHttpClient();
    }

    @Override
    public EmbeddingResponse embedding(String baseUrl, String apiKey, Embedding embeddingReq) throws Exception {
        if (baseUrl == null || "".equals(baseUrl)) {
            baseUrl = this.openAiConfig.getApiHost();
        }
        if (apiKey == null || "".equals(apiKey)) {
            apiKey = this.openAiConfig.getApiKey();
        }
        String jsonString = JSON.toJSONString((Object)embeddingReq);
        Request request = new Request.Builder().header("Authorization", "Bearer " + apiKey).url(ValidateUtil.concatUrl(baseUrl, this.openAiConfig.getEmbeddingUrl())).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonString)).build();
        Response execute = this.okHttpClient.newCall(request).execute();
        if (execute.isSuccessful() && execute.body() != null) {
            return (EmbeddingResponse)JSON.parseObject((String)execute.body().string(), EmbeddingResponse.class);
        }
        return null;
    }

    @Override
    public EmbeddingResponse embedding(Embedding embeddingReq) throws Exception {
        return this.embedding(null, null, embeddingReq);
    }
}

