/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.platform.openai.realtime;

import io.github.lnyocly.ai4j.config.OpenAiConfig;
import io.github.lnyocly.ai4j.listener.RealtimeListener;
import io.github.lnyocly.ai4j.service.Configuration;
import io.github.lnyocly.ai4j.service.IRealtimeService;
import io.github.lnyocly.ai4j.utils.ValidateUtil;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;

public class OpenAiRealtimeService
implements IRealtimeService {
    private final OpenAiConfig openAiConfig;
    private final OkHttpClient okHttpClient;

    public OpenAiRealtimeService(Configuration configuration) {
        this.openAiConfig = configuration.getOpenAiConfig();
        this.okHttpClient = configuration.getOkHttpClient();
    }

    @Override
    public WebSocket createRealtimeClient(String baseUrl, String apiKey, String model, RealtimeListener realtimeListener) {
        if (baseUrl == null || "".equals(baseUrl)) {
            baseUrl = this.openAiConfig.getApiHost();
        }
        if (apiKey == null || "".equals(apiKey)) {
            apiKey = this.openAiConfig.getApiKey();
        }
        String url = ValidateUtil.concatUrl(baseUrl, this.openAiConfig.getRealtimeUrl(), "?model=" + model);
        Request request = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + apiKey).addHeader("OpenAI-Beta", "realtime=v1").build();
        return this.okHttpClient.newWebSocket(request, (WebSocketListener)realtimeListener);
    }

    @Override
    public WebSocket createRealtimeClient(String model, RealtimeListener realtimeListener) {
        return this.createRealtimeClient(null, null, model, realtimeListener);
    }
}

