/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.platform.zhipu.chat;

import com.alibaba.fastjson2.JSON;
import io.github.lnyocly.ai4j.config.ZhipuConfig;
import io.github.lnyocly.ai4j.convert.chat.ParameterConvert;
import io.github.lnyocly.ai4j.convert.chat.ResultConvert;
import io.github.lnyocly.ai4j.listener.SseListener;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.ChatCompletion;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.ChatCompletionResponse;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.ChatMessage;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.Choice;
import io.github.lnyocly.ai4j.platform.openai.tool.Tool;
import io.github.lnyocly.ai4j.platform.openai.tool.ToolCall;
import io.github.lnyocly.ai4j.platform.openai.usage.Usage;
import io.github.lnyocly.ai4j.platform.zhipu.chat.entity.ZhipuChatCompletion;
import io.github.lnyocly.ai4j.platform.zhipu.chat.entity.ZhipuChatCompletionResponse;
import io.github.lnyocly.ai4j.service.Configuration;
import io.github.lnyocly.ai4j.service.IChatService;
import io.github.lnyocly.ai4j.utils.BearerTokenUtils;
import io.github.lnyocly.ai4j.utils.ToolUtil;
import io.github.lnyocly.ai4j.utils.ValidateUtil;
import java.util.ArrayList;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZhipuChatService
implements IChatService,
ParameterConvert<ZhipuChatCompletion>,
ResultConvert<ZhipuChatCompletionResponse> {
    private static final Logger log = LoggerFactory.getLogger(ZhipuChatService.class);
    private final ZhipuConfig zhipuConfig;
    private final OkHttpClient okHttpClient;
    private final EventSource.Factory factory;

    public ZhipuChatService(Configuration configuration) {
        this.zhipuConfig = configuration.getZhipuConfig();
        this.okHttpClient = configuration.getOkHttpClient();
        this.factory = configuration.createRequestFactory();
    }

    @Override
    public ChatCompletionResponse chatCompletion(String baseUrl, String apiKey, ChatCompletion chatCompletion) throws Exception {
        if (baseUrl == null || "".equals(baseUrl)) {
            baseUrl = this.zhipuConfig.getApiHost();
        }
        if (apiKey == null || "".equals(apiKey)) {
            apiKey = this.zhipuConfig.getApiKey();
        }
        chatCompletion.setStream(false);
        chatCompletion.setStreamOptions(null);
        String token = BearerTokenUtils.getToken(apiKey);
        ZhipuChatCompletion zhipuChatCompletion = this.convertChatCompletionObject(chatCompletion);
        if (zhipuChatCompletion.getFunctions() != null && !zhipuChatCompletion.getFunctions().isEmpty()) {
            List<Tool> tools = ToolUtil.getAllFunctionTools(zhipuChatCompletion.getFunctions());
            zhipuChatCompletion.setTools(tools);
        }
        Usage allUsage = new Usage();
        String finishReason = "first";
        while ("first".equals(finishReason) || "tool_calls".equals(finishReason)) {
            finishReason = null;
            String requestString = JSON.toJSONString((Object)zhipuChatCompletion);
            Request request = new Request.Builder().header("Authorization", "Bearer " + token).url(ValidateUtil.concatUrl(baseUrl, this.zhipuConfig.getChatCompletionUrl())).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)requestString)).build();
            Response execute = this.okHttpClient.newCall(request).execute();
            if (!execute.isSuccessful() || execute.body() == null) continue;
            ZhipuChatCompletionResponse zhipuChatCompletionResponse = (ZhipuChatCompletionResponse)JSON.parseObject((String)execute.body().string(), ZhipuChatCompletionResponse.class);
            Choice choice = zhipuChatCompletionResponse.getChoices().get(0);
            finishReason = choice.getFinishReason();
            Usage usage = zhipuChatCompletionResponse.getUsage();
            allUsage.setCompletionTokens(allUsage.getCompletionTokens() + usage.getCompletionTokens());
            allUsage.setTotalTokens(allUsage.getTotalTokens() + usage.getTotalTokens());
            allUsage.setPromptTokens(allUsage.getPromptTokens() + usage.getPromptTokens());
            if ("tool_calls".equals(finishReason)) {
                ChatMessage message = choice.getMessage();
                List<ToolCall> toolCalls = message.getToolCalls();
                ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>(zhipuChatCompletion.getMessages());
                messages.add(message);
                for (ToolCall toolCall : toolCalls) {
                    String functionName = toolCall.getFunction().getName();
                    String arguments = toolCall.getFunction().getArguments();
                    String functionResponse = ToolUtil.invoke(functionName, arguments);
                    messages.add(ChatMessage.withTool(functionResponse, toolCall.getId()));
                }
                zhipuChatCompletion.setMessages(messages);
                continue;
            }
            zhipuChatCompletionResponse.setUsage(allUsage);
            zhipuChatCompletionResponse.setObject("chat.completion");
            chatCompletion.setMessages(zhipuChatCompletion.getMessages());
            chatCompletion.setTools(zhipuChatCompletion.getTools());
            return this.convertChatCompletionResponse(zhipuChatCompletionResponse);
        }
        return null;
    }

    @Override
    public ChatCompletionResponse chatCompletion(ChatCompletion chatCompletion) throws Exception {
        return this.chatCompletion(null, null, chatCompletion);
    }

    @Override
    public void chatCompletionStream(String baseUrl, String apiKey, ChatCompletion chatCompletion, SseListener eventSourceListener) throws Exception {
        if (baseUrl == null || "".equals(baseUrl)) {
            baseUrl = this.zhipuConfig.getApiHost();
        }
        if (apiKey == null || "".equals(apiKey)) {
            apiKey = this.zhipuConfig.getApiKey();
        }
        chatCompletion.setStream(true);
        String token = BearerTokenUtils.getToken(apiKey);
        ZhipuChatCompletion zhipuChatCompletion = this.convertChatCompletionObject(chatCompletion);
        if (zhipuChatCompletion.getFunctions() != null && !zhipuChatCompletion.getFunctions().isEmpty()) {
            List<Tool> tools = ToolUtil.getAllFunctionTools(zhipuChatCompletion.getFunctions());
            zhipuChatCompletion.setTools(tools);
        }
        String finishReason = "first";
        while ("first".equals(finishReason) || "tool_calls".equals(finishReason)) {
            finishReason = null;
            String jsonString = JSON.toJSONString((Object)zhipuChatCompletion);
            Request request = new Request.Builder().header("Authorization", "Bearer " + token).url(ValidateUtil.concatUrl(baseUrl, this.zhipuConfig.getChatCompletionUrl())).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonString)).build();
            this.factory.newEventSource(request, this.convertEventSource(eventSourceListener));
            eventSourceListener.getCountDownLatch().await();
            finishReason = eventSourceListener.getFinishReason();
            List<ToolCall> toolCalls = eventSourceListener.getToolCalls();
            if (!"tool_calls".equals(finishReason) || toolCalls.isEmpty()) continue;
            ChatMessage responseMessage = ChatMessage.withAssistant(eventSourceListener.getToolCalls());
            ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>(zhipuChatCompletion.getMessages());
            messages.add(responseMessage);
            for (ToolCall toolCall : toolCalls) {
                String functionName = toolCall.getFunction().getName();
                String arguments = toolCall.getFunction().getArguments();
                String functionResponse = ToolUtil.invoke(functionName, arguments);
                messages.add(ChatMessage.withTool(functionResponse, toolCall.getId()));
            }
            eventSourceListener.setToolCalls(new ArrayList<ToolCall>());
            eventSourceListener.setToolCall(null);
            zhipuChatCompletion.setMessages(messages);
        }
        chatCompletion.setMessages(zhipuChatCompletion.getMessages());
        chatCompletion.setTools(zhipuChatCompletion.getTools());
    }

    @Override
    public void chatCompletionStream(ChatCompletion chatCompletion, SseListener eventSourceListener) throws Exception {
        this.chatCompletionStream(null, null, chatCompletion, eventSourceListener);
    }

    @Override
    public ZhipuChatCompletion convertChatCompletionObject(ChatCompletion chatCompletion) {
        ZhipuChatCompletion zhipuChatCompletion = new ZhipuChatCompletion();
        zhipuChatCompletion.setModel(chatCompletion.getModel());
        zhipuChatCompletion.setMessages(chatCompletion.getMessages());
        zhipuChatCompletion.setStream(chatCompletion.getStream());
        zhipuChatCompletion.setTemperature(Float.valueOf(chatCompletion.getTemperature().floatValue() / 2.0f));
        zhipuChatCompletion.setTopP(chatCompletion.getTopP());
        zhipuChatCompletion.setMaxTokens(chatCompletion.getMaxTokens());
        zhipuChatCompletion.setStop(chatCompletion.getStop());
        zhipuChatCompletion.setTools(chatCompletion.getTools());
        zhipuChatCompletion.setFunctions(chatCompletion.getFunctions());
        zhipuChatCompletion.setToolChoice(chatCompletion.getToolChoice());
        return zhipuChatCompletion;
    }

    @Override
    public EventSourceListener convertEventSource(final SseListener eventSourceListener) {
        return new EventSourceListener(){

            public void onOpen(@NotNull EventSource eventSource, @NotNull Response response) {
                eventSourceListener.onOpen(eventSource, response);
            }

            public void onFailure(@NotNull EventSource eventSource, @Nullable Throwable t, @Nullable Response response) {
                eventSourceListener.onFailure(eventSource, t, response);
            }

            public void onEvent(@NotNull EventSource eventSource, @Nullable String id, @Nullable String type, @NotNull String data) {
                if ("[DONE]".equalsIgnoreCase(data)) {
                    eventSourceListener.onEvent(eventSource, id, type, data);
                    return;
                }
                ZhipuChatCompletionResponse chatCompletionResponse = (ZhipuChatCompletionResponse)JSON.parseObject((String)data, ZhipuChatCompletionResponse.class);
                chatCompletionResponse.setObject("chat.completion.chunk");
                ChatCompletionResponse response = ZhipuChatService.this.convertChatCompletionResponse(chatCompletionResponse);
                eventSourceListener.onEvent(eventSource, id, type, JSON.toJSONString((Object)response));
            }

            public void onClosed(@NotNull EventSource eventSource) {
                eventSourceListener.onClosed(eventSource);
            }
        };
    }

    @Override
    public ChatCompletionResponse convertChatCompletionResponse(ZhipuChatCompletionResponse zhipuChatCompletionResponse) {
        ChatCompletionResponse chatCompletionResponse = new ChatCompletionResponse();
        chatCompletionResponse.setId(zhipuChatCompletionResponse.getId());
        chatCompletionResponse.setCreated(zhipuChatCompletionResponse.getCreated());
        chatCompletionResponse.setModel(zhipuChatCompletionResponse.getModel());
        chatCompletionResponse.setChoices(zhipuChatCompletionResponse.getChoices());
        chatCompletionResponse.setUsage(zhipuChatCompletionResponse.getUsage());
        return chatCompletionResponse;
    }
}

