/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.websearch;

import com.alibaba.fastjson2.JSON;
import io.github.lnyocly.ai4j.exception.CommonException;
import io.github.lnyocly.ai4j.listener.SseListener;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.ChatCompletion;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.ChatCompletionResponse;
import io.github.lnyocly.ai4j.service.Configuration;
import io.github.lnyocly.ai4j.service.IChatService;
import io.github.lnyocly.ai4j.utils.ValidateUtil;
import io.github.lnyocly.ai4j.websearch.searxng.SearXNGConfig;
import io.github.lnyocly.ai4j.websearch.searxng.SearXNGRequest;
import io.github.lnyocly.ai4j.websearch.searxng.SearXNGResponse;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

public class ChatWithWebSearchEnhance
implements IChatService {
    private final IChatService chatService;
    private final SearXNGConfig searXNGConfig;
    private final OkHttpClient okHttpClient;

    public ChatWithWebSearchEnhance(IChatService chatService, Configuration configuration) {
        this.chatService = chatService;
        this.searXNGConfig = configuration.getSearXNGConfig();
        this.okHttpClient = configuration.getOkHttpClient();
    }

    @Override
    public ChatCompletionResponse chatCompletion(String baseUrl, String apiKey, ChatCompletion chatCompletion) throws Exception {
        return this.chatService.chatCompletion(baseUrl, apiKey, this.addWebSearchResults(chatCompletion));
    }

    @Override
    public ChatCompletionResponse chatCompletion(ChatCompletion chatCompletion) throws Exception {
        return this.chatService.chatCompletion(this.addWebSearchResults(chatCompletion));
    }

    @Override
    public void chatCompletionStream(String baseUrl, String apiKey, ChatCompletion chatCompletion, SseListener eventSourceListener) throws Exception {
        this.chatService.chatCompletionStream(baseUrl, apiKey, this.addWebSearchResults(chatCompletion), eventSourceListener);
    }

    @Override
    public void chatCompletionStream(ChatCompletion chatCompletion, SseListener eventSourceListener) throws Exception {
        this.chatService.chatCompletionStream(this.addWebSearchResults(chatCompletion), eventSourceListener);
    }

    private ChatCompletion addWebSearchResults(ChatCompletion chatCompletion) {
        int chatLen = chatCompletion.getMessages().size();
        String prompt = chatCompletion.getMessages().get(chatLen - 1).getContent();
        String searchResults = this.performWebSearch(prompt);
        chatCompletion.getMessages().get(chatLen - 1).setContent("\u6211\u5c06\u63d0\u4f9b\u4e00\u6bb5\u6765\u81ea\u4e92\u8054\u7f51\u7684\u8d44\u6599\u4fe1\u606f, \u8bf7\u6839\u636e\u8fd9\u6bb5\u8d44\u6599\u4ee5\u53ca\u7528\u6237\u63d0\u51fa\u7684\u95ee\u9898\u6765\u7ed9\u51fa\u56de\u7b54\u3002\u8bf7\u786e\u4fdd\u5728\u56de\u7b54\u4e2d\u4f7f\u7528Markdown\u683c\u5f0f\uff0c\u5e76\u5728\u56de\u7b54\u672b\u5c3e\u5217\u51fa\u53c2\u8003\u8d44\u6599\u3002\u5982\u679c\u8d44\u6599\u4e2d\u7684\u4fe1\u606f\u4e0d\u8db3\u4ee5\u56de\u7b54\u7528\u6237\u7684\u95ee\u9898\uff0c\u53ef\u4ee5\u6839\u636e\u81ea\u8eab\u77e5\u8bc6\u5e93\u8fdb\u884c\u8865\u5145\uff0c\u6216\u8005\u8bf4\u660e\u65e0\u6cd5\u63d0\u4f9b\u786e\u5207\u7684\u7b54\u6848\u3002\n\u7f51\u7edc\u8d44\u6599:\n============\n" + searchResults + "============\n\u7528\u6237\u95ee\u9898:\n============\n" + prompt + "============\n");
        return chatCompletion;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String performWebSearch(String query) {
        SearXNGRequest searXNGRequest = SearXNGRequest.builder().q(query).engines(this.searXNGConfig.getEngines()).build();
        if (StringUtils.isBlank((CharSequence)this.searXNGConfig.getUrl())) {
            throw new CommonException("SearXNG url is not configured");
        }
        Request request = new Request.Builder().url(ValidateUtil.concatUrl(this.searXNGConfig.getUrl(), "?format=json&q=" + query + "&engines=" + this.searXNGConfig.getEngines())).get().build();
        try (Response execute = this.okHttpClient.newCall(request).execute();){
            if (!execute.isSuccessful()) throw new CommonException("SearXNG request failed");
            if (execute.body() == null) throw new CommonException("SearXNG request failed");
            SearXNGResponse searXNGResponse = (SearXNGResponse)JSON.parseObject((String)execute.body().string(), SearXNGResponse.class);
            if (searXNGResponse.getResults().size() > this.searXNGConfig.getNums()) {
                String string = JSON.toJSONString(searXNGResponse.getResults().subList(0, this.searXNGConfig.getNums()));
                return string;
            }
            String string = JSON.toJSONString(searXNGResponse.getResults());
            return string;
        }
        catch (Exception e) {
            throw new CommonException("SearXNG request failed");
        }
    }
}

