// Generated by delombok at Thu Apr 07 05:50:18 UTC 2022
package org.lognet.springboot.grpc.security;

import io.grpc.Metadata;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.function.Supplier;

public class AuthHeader implements Constants {
    private final Supplier<ByteBuffer> tokenSupplier;
    private final String authScheme;
    private final boolean binaryFormat;


    public static class AuthHeaderBuilder {
        @java.lang.SuppressWarnings("all")
        private Supplier<ByteBuffer> tokenSupplier;
        @java.lang.SuppressWarnings("all")
        private String authScheme;
        @java.lang.SuppressWarnings("all")
        private boolean binaryFormat$set;
        @java.lang.SuppressWarnings("all")
        private boolean binaryFormat$value;

        public AuthHeader.AuthHeaderBuilder bearer() {
            return authScheme(Constants.BEARER_AUTH_SCHEME);
        }

        public AuthHeader.AuthHeaderBuilder basic() {
            return authScheme(Constants.BASIC_AUTH_SCHEME);
        }

        public AuthHeader.AuthHeaderBuilder basic(String userName, byte[] password) {
            final ByteBuffer buffer = ByteBuffer.allocate(userName.length() + password.length + 1).put(userName.getBytes()).put((byte) ':').put(password);
            buffer.rewind();
            ByteBuffer token = Base64.getEncoder().encode(buffer);
            token.rewind();
            return authScheme(Constants.BASIC_AUTH_SCHEME).tokenSupplier(token::duplicate);
        }

        @java.lang.SuppressWarnings("all")
        AuthHeaderBuilder() {
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public AuthHeader.AuthHeaderBuilder tokenSupplier(final Supplier<ByteBuffer> tokenSupplier) {
            this.tokenSupplier = tokenSupplier;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public AuthHeader.AuthHeaderBuilder authScheme(final String authScheme) {
            this.authScheme = authScheme;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        public AuthHeader.AuthHeaderBuilder binaryFormat(final boolean binaryFormat) {
            this.binaryFormat$value = binaryFormat;
            binaryFormat$set = true;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public AuthHeader build() {
            boolean binaryFormat$value = this.binaryFormat$value;
            if (!this.binaryFormat$set) binaryFormat$value = AuthHeader.$default$binaryFormat();
            return new AuthHeader(this.tokenSupplier, this.authScheme, binaryFormat$value);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "AuthHeader.AuthHeaderBuilder(tokenSupplier=" + this.tokenSupplier + ", authScheme=" + this.authScheme + ", binaryFormat$value=" + this.binaryFormat$value + ")";
        }
    }

    public Metadata attach(Metadata metadataHeader) {
        ByteBuffer token = tokenSupplier.get();
        final byte[] header = ByteBuffer.allocate(authScheme.length() + token.remaining() + 1).put(authScheme.getBytes()).put((byte) ' ').put(token).array();
        if (binaryFormat) {
            metadataHeader.put(Constants.AUTH_HEADER_BIN_KEY, header);
        } else {
            metadataHeader.put(Constants.AUTH_HEADER_KEY, new String(header));
        }
        return metadataHeader;
    }

    @java.lang.SuppressWarnings("all")
    private static boolean $default$binaryFormat() {
        return true;
    }

    @java.lang.SuppressWarnings("all")
    AuthHeader(final Supplier<ByteBuffer> tokenSupplier, final String authScheme, final boolean binaryFormat) {
        this.tokenSupplier = tokenSupplier;
        this.authScheme = authScheme;
        this.binaryFormat = binaryFormat;
    }

    @java.lang.SuppressWarnings("all")
    public static AuthHeader.AuthHeaderBuilder builder() {
        return new AuthHeader.AuthHeaderBuilder();
    }
}
