/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.autoconfigure;

import io.grpc.ServerBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import io.grpc.services.HealthStatusManager;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Consumer;
import org.lognet.springboot.grpc.GRpcServerBuilderConfigurer;
import org.lognet.springboot.grpc.GRpcServerRunner;
import org.lognet.springboot.grpc.GRpcService;
import org.lognet.springboot.grpc.autoconfigure.GRpcServerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfigureOrder
@ConditionalOnBean(annotation={GRpcService.class})
@EnableConfigurationProperties(value={GRpcServerProperties.class})
public class GRpcAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GRpcAutoConfiguration.class);
    @Autowired
    private GRpcServerProperties grpcServerProperties;

    @Bean
    @ConditionalOnProperty(value={"grpc.enabled"}, havingValue="true", matchIfMissing=true)
    public GRpcServerRunner grpcServerRunner(@Qualifier(value="grpcInternalConfigurator") Consumer<ServerBuilder<?>> configurator) {
        return new GRpcServerRunner(configurator, ServerBuilder.forPort((int)this.grpcServerProperties.getRunningPort()));
    }

    @Bean
    @ConditionalOnExpression(value="#{environment.getProperty('grpc.inProcessServerName','')!=''}")
    public GRpcServerRunner grpcInprocessServerRunner(@Qualifier(value="grpcInternalConfigurator") Consumer<ServerBuilder<?>> configurator) {
        return new GRpcServerRunner(configurator, (ServerBuilder<?>)InProcessServerBuilder.forName((String)this.grpcServerProperties.getInProcessServerName()));
    }

    @Bean
    public HealthStatusManager healthStatusManager() {
        return new HealthStatusManager();
    }

    @Bean
    @ConditionalOnMissingBean(value={GRpcServerBuilderConfigurer.class})
    public GRpcServerBuilderConfigurer serverBuilderConfigurer() {
        return new GRpcServerBuilderConfigurer();
    }

    @Bean(name={"grpcInternalConfigurator"})
    public Consumer<ServerBuilder<?>> configurator(GRpcServerBuilderConfigurer configurer) {
        return serverBuilder -> {
            if (this.grpcServerProperties.isEnabled()) {
                Optional.ofNullable(this.grpcServerProperties.getSecurity()).ifPresent(s -> {
                    boolean setupSecurity = Optional.ofNullable(s.getCertChain()).isPresent();
                    if (setupSecurity != Optional.ofNullable(s.getPrivateKey()).isPresent()) {
                        throw new BeanCreationException("Both  gRPC  TLS 'certChain' and 'privateKey' should be configured. One of them is null. ");
                    }
                    if (setupSecurity) {
                        try {
                            serverBuilder.useTransportSecurity(s.getCertChain().getInputStream(), s.getPrivateKey().getInputStream());
                        }
                        catch (IOException e) {
                            throw new BeanCreationException("Failed to setup security", (Throwable)e);
                        }
                    }
                });
            }
            configurer.configure((ServerBuilder<?>)serverBuilder);
        };
    }
}

