/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.autoconfigure;

import java.util.Optional;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.Resource;
import org.springframework.util.SocketUtils;

@ConfigurationProperties(value="grpc")
public class GRpcServerProperties {
    public static final int DEFAULT_GRPC_PORT = 6565;
    private Integer port = null;
    private SecurityProperties security;
    private volatile Integer runningPort = null;
    private boolean enabled = true;
    private String inProcessServerName;
    private boolean enableReflection = false;
    private int shutdownGrace = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getRunningPort() {
        if (null == this.runningPort) {
            GRpcServerProperties gRpcServerProperties = this;
            synchronized (gRpcServerProperties) {
                if (null == this.runningPort) {
                    this.runningPort = Optional.ofNullable(this.port).map(p -> 0 == p ? SocketUtils.findAvailableTcpPort() : p).orElse(6565);
                }
            }
        }
        return this.runningPort;
    }

    public Integer getPort() {
        return this.port;
    }

    public SecurityProperties getSecurity() {
        return this.security;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getInProcessServerName() {
        return this.inProcessServerName;
    }

    public boolean isEnableReflection() {
        return this.enableReflection;
    }

    public int getShutdownGrace() {
        return this.shutdownGrace;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setSecurity(SecurityProperties security) {
        this.security = security;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setInProcessServerName(String inProcessServerName) {
        this.inProcessServerName = inProcessServerName;
    }

    public void setEnableReflection(boolean enableReflection) {
        this.enableReflection = enableReflection;
    }

    public void setShutdownGrace(int shutdownGrace) {
        this.shutdownGrace = shutdownGrace;
    }

    public static class SecurityProperties {
        private Resource certChain;
        private Resource privateKey;

        public Resource getCertChain() {
            return this.certChain;
        }

        public Resource getPrivateKey() {
            return this.privateKey;
        }

        public void setCertChain(Resource certChain) {
            this.certChain = certChain;
        }

        public void setPrivateKey(Resource privateKey) {
            this.privateKey = privateKey;
        }
    }
}

