/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.security;

import io.grpc.Context;
import io.grpc.ServerInterceptor;
import java.util.Arrays;
import org.lognet.springboot.grpc.security.AuthenticatedAttributeVoter;
import org.lognet.springboot.grpc.security.AuthenticationSchemeSelector;
import org.lognet.springboot.grpc.security.AuthenticationSchemeService;
import org.lognet.springboot.grpc.security.GrpcSecurityMetadataSource;
import org.lognet.springboot.grpc.security.GrpcServiceAuthorizationConfigurer;
import org.lognet.springboot.grpc.security.SecurityInterceptor;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.AbstractConfiguredSecurityBuilder;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.SecurityBuilder;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetailsService;

public class GrpcSecurity
extends AbstractConfiguredSecurityBuilder<ServerInterceptor, GrpcSecurity>
implements SecurityBuilder<ServerInterceptor>,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    public static final Context.Key<Authentication> AUTHENTICATION_CONTEXT_KEY = Context.key((String)"AUTHENTICATION");

    public GrpcSecurity(ObjectPostProcessor<Object> objectPostProcessor) {
        super(objectPostProcessor);
    }

    public GrpcServiceAuthorizationConfigurer.Registry authorizeRequests() throws Exception {
        return this.getOrApply(new GrpcServiceAuthorizationConfigurer(this.applicationContext)).getRegistry();
    }

    public GrpcSecurity userDetailsService(UserDetailsService userDetailsService) throws Exception {
        this.getAuthenticationRegistry().userDetailsService(userDetailsService);
        return this;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public GrpcSecurity authenticationSchemeSelector(AuthenticationSchemeSelector selector) {
        this.getAuthenticationSchemeService().register(selector);
        return this;
    }

    public GrpcSecurity authenticationProvider(AuthenticationProvider authenticationProvider) {
        this.getAuthenticationRegistry().authenticationProvider(authenticationProvider);
        return this;
    }

    protected void beforeConfigure() throws Exception {
    }

    protected ServerInterceptor performBuild() throws Exception {
        SecurityInterceptor securityInterceptor = new SecurityInterceptor((GrpcSecurityMetadataSource)this.getSharedObject(GrpcSecurityMetadataSource.class), this.getAuthenticationSchemeService());
        securityInterceptor.setAuthenticationManager((AuthenticationManager)((AuthenticationManagerBuilder)this.getSharedObject(AuthenticationManagerBuilder.class)).build());
        RoleVoter scopeVoter = new RoleVoter();
        scopeVoter.setRolePrefix("SCOPE_");
        securityInterceptor.setAccessDecisionManager((AccessDecisionManager)new AffirmativeBased(Arrays.asList(new RoleVoter(), scopeVoter, new AuthenticatedAttributeVoter())));
        return securityInterceptor;
    }

    private <C extends SecurityConfigurerAdapter<ServerInterceptor, GrpcSecurity>> C getOrApply(C configurer) throws Exception {
        SecurityConfigurerAdapter existingConfig = (SecurityConfigurerAdapter)this.getConfigurer(configurer.getClass());
        if (existingConfig != null) {
            return (C)existingConfig;
        }
        return (C)this.apply(configurer);
    }

    private AuthenticationManagerBuilder getAuthenticationRegistry() {
        return (AuthenticationManagerBuilder)this.getSharedObject(AuthenticationManagerBuilder.class);
    }

    private AuthenticationSchemeService getAuthenticationSchemeService() {
        return (AuthenticationSchemeService)this.getSharedObject(AuthenticationSchemeService.class);
    }
}

