/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.security;

import org.lognet.springboot.grpc.security.AuthenticationSchemeService;
import org.lognet.springboot.grpc.security.BasicAuthSchemeSelector;
import org.lognet.springboot.grpc.security.BearerTokenAuthSchemeSelector;
import org.lognet.springboot.grpc.security.GrpcSecurity;
import org.lognet.springboot.grpc.security.GrpcSecurityConfigurer;
import org.lognet.springboot.grpc.security.GrpcServiceAuthorizationConfigurer;
import org.lognet.springboot.grpc.security.jwt.JwtAuthProviderFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.oauth2.jwt.JwtDecoder;

public abstract class GrpcSecurityConfigurerAdapter
extends GrpcSecurityConfigurer<GrpcSecurity> {
    private AuthenticationConfiguration authenticationConfiguration;
    private AuthenticationManagerBuilder authenticationManagerBuilder;
    private ApplicationContext context;

    protected GrpcSecurityConfigurerAdapter() {
    }

    @Autowired
    public void setApplicationContext(ApplicationContext context) throws Exception {
        ObjectPostProcessor objectPostProcessor = (ObjectPostProcessor)context.getBean(ObjectPostProcessor.class);
        this.authenticationConfiguration = (AuthenticationConfiguration)context.getBean(AuthenticationConfiguration.class);
        this.authenticationManagerBuilder = this.authenticationConfiguration.authenticationManagerBuilder(objectPostProcessor, context).parentAuthenticationManager(this.authenticationConfiguration.getAuthenticationManager());
        this.context = context;
    }

    public void init(GrpcSecurity builder) throws Exception {
        builder.apply(new GrpcServiceAuthorizationConfigurer(builder.getApplicationContext()));
        builder.setSharedObject(AuthenticationManagerBuilder.class, this.authenticationManagerBuilder);
        AuthenticationSchemeService authenticationSchemeService = new AuthenticationSchemeService();
        authenticationSchemeService.register(new BasicAuthSchemeSelector());
        authenticationSchemeService.register(new BearerTokenAuthSchemeSelector());
        builder.setSharedObject(AuthenticationSchemeService.class, authenticationSchemeService);
    }

    public void configure(GrpcSecurity builder) throws Exception {
        try {
            Class<?> jwtDecoderClass = Class.forName("org.springframework.security.oauth2.jwt.JwtDecoder");
            String[] beanNames = this.context.getBeanNamesForType(jwtDecoderClass);
            if (1 == beanNames.length) {
                builder.authenticationProvider((AuthenticationProvider)JwtAuthProviderFactory.forAuthorities((JwtDecoder)this.context.getBean(beanNames[0], JwtDecoder.class)));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        builder.authorizeRequests().withSecuredAnnotation();
    }

    public ApplicationContext getContext() {
        return this.context;
    }
}

