/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.security.jwt;

import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minidev.json.JSONNavi;
import net.minidev.json.JSONObject;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationProvider;
import org.springframework.util.Assert;

public class JwtAuthProviderFactory {
    public static JwtAuthenticationProvider forRoles(JwtDecoder jwtDecoder) {
        JwtAuthenticationConverter authenticationConverter = new JwtAuthenticationConverter();
        authenticationConverter.setJwtGrantedAuthoritiesConverter(jwt -> {
            String claim = Optional.ofNullable(jwt.getClaimAsString("aud")).orElse(jwt.getClaimAsString("azp"));
            Assert.hasText((String)claim, (String)"Neither aud nor azp claims exist");
            JSONObject resourceAccess = (JSONObject)jwt.getClaim("resource_access");
            JSONNavi roles = JSONNavi.newInstanceArray().add(new Object[]{resourceAccess}).at(0).at(claim).at("roles");
            return IntStream.range(0, roles.getSize()).mapToObj(k -> new SimpleGrantedAuthority("ROLE_" + roles.get(k).toString())).collect(Collectors.toList());
        });
        JwtAuthenticationProvider authenticationProvider = new JwtAuthenticationProvider(jwtDecoder);
        authenticationProvider.setJwtAuthenticationConverter((Converter)authenticationConverter);
        return authenticationProvider;
    }

    public static JwtAuthenticationProvider forAuthorities(JwtDecoder jwtDecoder) {
        return new JwtAuthenticationProvider(jwtDecoder);
    }
}

