// Generated by delombok at Mon Nov 16 10:28:57 UTC 2020
package org.lognet.springboot.grpc.security;

import org.springframework.security.core.Authentication;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

class AuthenticationSchemeService implements AuthenticationSchemeRegistry, AuthenticationSchemeSelector {
    @java.lang.SuppressWarnings("all")
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(AuthenticationSchemeService.class);
    private List<AuthenticationSchemeSelector> selectors = new ArrayList<>();

    @Override
    public Optional<Authentication> getAuthScheme(CharSequence authorization) {
        final List<Authentication> auth = selectors.stream().map(selector -> selector.getAuthScheme(authorization)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        switch (auth.size()) {
        case 0: 
            throw new IllegalStateException("Authentication scheme" + authorization.toString() + "not supported");
        case 1: 
            return Optional.of(auth.get(0));
        default: 
            throw new IllegalStateException("Ambiguous authentication scheme " + authorization.toString());
        }
    }

    @Override
    public AuthenticationSchemeRegistry register(AuthenticationSchemeSelector selector) {
        selectors.add(selector);
        return this;
    }
}
