/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.protobuf.services.ProtoReflectionService;
import io.grpc.services.HealthStatusManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.lognet.springboot.grpc.GRpcGlobalInterceptor;
import org.lognet.springboot.grpc.GRpcService;
import org.lognet.springboot.grpc.autoconfigure.GRpcServerProperties;
import org.lognet.springboot.grpc.context.GRpcServerInitializedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class GRpcServerRunner
implements CommandLineRunner,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(GRpcServerRunner.class);
    @Autowired
    private HealthStatusManager healthStatusManager;
    @Autowired
    private AbstractApplicationContext applicationContext;
    @Autowired
    private GRpcServerProperties gRpcServerProperties;
    private final Consumer<ServerBuilder<?>> configurator;
    private Server server;
    private final ServerBuilder<?> serverBuilder;
    private final CountDownLatch latch;

    public GRpcServerRunner(Consumer<ServerBuilder<?>> configurator, ServerBuilder<?> serverBuilder) {
        this.configurator = configurator;
        this.serverBuilder = serverBuilder;
        this.latch = new CountDownLatch(1);
    }

    public void run(String ... args) throws Exception {
        log.info("Starting gRPC Server ...");
        Collection globalInterceptors = this.getBeanNamesByTypeWithAnnotation(GRpcGlobalInterceptor.class, ServerInterceptor.class).map(name -> (ServerInterceptor)this.applicationContext.getBeanFactory().getBean(name, ServerInterceptor.class)).collect(Collectors.toList());
        this.serverBuilder.addService(this.healthStatusManager.getHealthService());
        this.getBeanNamesByTypeWithAnnotation(GRpcService.class, BindableService.class).forEach(name -> {
            BindableService srv = (BindableService)this.applicationContext.getBeanFactory().getBean(name, BindableService.class);
            ServerServiceDefinition serviceDefinition = srv.bindService();
            GRpcService gRpcServiceAnn = (GRpcService)this.applicationContext.findAnnotationOnBean(name, GRpcService.class);
            serviceDefinition = this.bindInterceptors(serviceDefinition, gRpcServiceAnn, globalInterceptors);
            this.serverBuilder.addService(serviceDefinition);
            String serviceName = serviceDefinition.getServiceDescriptor().getName();
            this.healthStatusManager.setStatus(serviceName, HealthCheckResponse.ServingStatus.SERVING);
            log.info("'{}' service has been registered.", (Object)srv.getClass().getName());
        });
        if (this.gRpcServerProperties.isEnableReflection()) {
            this.serverBuilder.addService(ProtoReflectionService.newInstance());
            log.info("'{}' service has been registered.", (Object)ProtoReflectionService.class.getName());
        }
        this.configurator.accept(this.serverBuilder);
        this.server = this.serverBuilder.build().start();
        this.applicationContext.publishEvent((ApplicationEvent)new GRpcServerInitializedEvent((ApplicationContext)this.applicationContext, this.server));
        log.info("gRPC Server started, listening on port {}.", (Object)this.server.getPort());
        this.startDaemonAwaitThread();
    }

    private ServerServiceDefinition bindInterceptors(ServerServiceDefinition serviceDefinition, GRpcService gRpcService, Collection<ServerInterceptor> globalInterceptors) {
        Stream<ServerInterceptor> privateInterceptors = Stream.of(gRpcService.interceptors()).map(interceptorClass -> {
            try {
                return 0 < this.applicationContext.getBeanNamesForType(interceptorClass).length ? (ServerInterceptor)this.applicationContext.getBean(interceptorClass) : (ServerInterceptor)interceptorClass.newInstance();
            }
            catch (Exception e) {
                throw new BeanCreationException("Failed to create interceptor instance.", (Throwable)e);
            }
        });
        List interceptors = Stream.concat(gRpcService.applyGlobalInterceptors() ? globalInterceptors.stream() : Stream.empty(), privateInterceptors).distinct().sorted(this.serverInterceptorOrderComparator()).collect(Collectors.toList());
        return ServerInterceptors.intercept((ServerServiceDefinition)serviceDefinition, interceptors);
    }

    private Comparator<Object> serverInterceptorOrderComparator() {
        Function<Object, Boolean> isOrderAnnotated = obj -> {
            Order ann = obj instanceof Method ? (Order)AnnotationUtils.findAnnotation((Method)((Method)obj), Order.class) : (Order)AnnotationUtils.findAnnotation(obj.getClass(), Order.class);
            return ann != null;
        };
        return AnnotationAwareOrderComparator.INSTANCE.thenComparing((o1, o2) -> {
            boolean p1 = (Boolean)isOrderAnnotated.apply(o1);
            boolean p2 = (Boolean)isOrderAnnotated.apply(o2);
            return p1 && !p2 ? -1 : (p2 && !p1 ? 1 : 0);
        }).reversed();
    }

    private void startDaemonAwaitThread() {
        Thread awaitThread = new Thread(() -> {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                log.error("gRPC server awaiter interrupted.", (Throwable)e);
            }
        });
        awaitThread.setName("grpc-server-awaiter");
        awaitThread.setDaemon(false);
        awaitThread.start();
    }

    public void destroy() throws Exception {
        Optional.ofNullable(this.server).ifPresent(s -> {
            log.info("Shutting down gRPC server ...");
            s.getServices().forEach(def -> this.healthStatusManager.clearStatus(def.getServiceDescriptor().getName()));
            s.shutdown();
            int shutdownGrace = this.gRpcServerProperties.getShutdownGrace();
            try {
                if (shutdownGrace < 0) {
                    s.awaitTermination();
                } else if (shutdownGrace > 0) {
                    s.awaitTermination((long)shutdownGrace, TimeUnit.SECONDS);
                }
            }
            catch (InterruptedException e) {
                log.error("gRPC server interrupted during destroy.", (Throwable)e);
            }
            finally {
                this.latch.countDown();
            }
            log.info("gRPC server stopped.");
        });
    }

    private <T> Stream<String> getBeanNamesByTypeWithAnnotation(Class<? extends Annotation> annotationType, Class<T> beanType) throws Exception {
        return Stream.of(this.applicationContext.getBeanNamesForType(beanType)).filter(name -> {
            BeanDefinition beanDefinition = this.applicationContext.getBeanFactory().getBeanDefinition(name);
            Map beansWithAnnotation = this.applicationContext.getBeansWithAnnotation(annotationType);
            if (beansWithAnnotation.containsKey(name)) {
                return true;
            }
            if (beanDefinition.getSource() instanceof AnnotatedTypeMetadata) {
                return ((AnnotatedTypeMetadata)AnnotatedTypeMetadata.class.cast(beanDefinition.getSource())).isAnnotated(annotationType.getName());
            }
            return false;
        });
    }
}

