/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.autoconfigure;

import io.grpc.ServerBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.services.HealthStatusManager;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.lognet.springboot.grpc.GRpcServerBuilderConfigurer;
import org.lognet.springboot.grpc.GRpcServerRunner;
import org.lognet.springboot.grpc.GRpcService;
import org.lognet.springboot.grpc.autoconfigure.GRpcServerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.SocketUtils;

@AutoConfigureOrder
@ConditionalOnBean(annotation={GRpcService.class})
@EnableConfigurationProperties(value={GRpcServerProperties.class})
public class GRpcAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GRpcAutoConfiguration.class);
    @Autowired
    private GRpcServerProperties grpcServerProperties;

    @Bean
    @ConditionalOnProperty(value={"grpc.enabled"}, havingValue="true", matchIfMissing=true)
    public GRpcServerRunner grpcServerRunner(@Qualifier(value="grpcInternalConfigurator") Consumer<ServerBuilder<?>> configurator) {
        ServerBuilder serverBuilder = Optional.ofNullable(this.grpcServerProperties.getNettyServer()).map(n -> {
            NettyServerBuilder builder = Optional.ofNullable(n.getPrimaryListenAddress()).map(NettyServerBuilder::forAddress).orElse(NettyServerBuilder.forPort((int)this.grpcServerProperties.getRunningPort()));
            Optional.ofNullable(n.getAdditionalListenAddresses()).ifPresent(l -> l.forEach(arg_0 -> ((NettyServerBuilder)builder).addListenAddress(arg_0)));
            Optional.ofNullable(n.getFlowControlWindow()).ifPresent(arg_0 -> ((NettyServerBuilder)builder).flowControlWindow(arg_0));
            Optional.ofNullable(n.getInitialFlowControlWindow()).ifPresent(arg_0 -> ((NettyServerBuilder)builder).initialFlowControlWindow(arg_0));
            Optional.ofNullable(n.getKeepAliveTime()).ifPresent(t -> builder.keepAliveTime(t.toMillis(), TimeUnit.MILLISECONDS));
            Optional.ofNullable(n.getKeepAliveTimeout()).ifPresent(t -> builder.keepAliveTimeout(t.toMillis(), TimeUnit.MILLISECONDS));
            Optional.ofNullable(n.getPermitKeepAliveTime()).ifPresent(t -> builder.permitKeepAliveTime(t.toMillis(), TimeUnit.MILLISECONDS));
            Optional.ofNullable(n.getMaxConnectionAge()).ifPresent(t -> builder.maxConnectionAge(t.toMillis(), TimeUnit.MILLISECONDS));
            Optional.ofNullable(n.getMaxConnectionAgeGrace()).ifPresent(t -> builder.maxConnectionAgeGrace(t.toMillis(), TimeUnit.MILLISECONDS));
            Optional.ofNullable(n.getMaxConnectionIdle()).ifPresent(t -> builder.maxConnectionIdle(t.toMillis(), TimeUnit.MILLISECONDS));
            Optional.ofNullable(n.getMaxConcurrentCallsPerConnection()).ifPresent(arg_0 -> ((NettyServerBuilder)builder).maxConcurrentCallsPerConnection(arg_0));
            Optional.ofNullable(n.getPermitKeepAliveWithoutCalls()).ifPresent(arg_0 -> ((NettyServerBuilder)builder).permitKeepAliveWithoutCalls(arg_0));
            Optional.ofNullable(n.getMaxInboundMessageSize()).ifPresent(s -> builder.maxInboundMessageSize((int)s.toBytes()));
            Optional.ofNullable(n.getMaxInboundMetadataSize()).ifPresent(s -> builder.maxInboundMetadataSize((int)s.toBytes()));
            return builder;
        }).orElse(ServerBuilder.forPort((int)this.grpcServerProperties.getRunningPort()));
        return new GRpcServerRunner(configurator, serverBuilder);
    }

    @Bean
    @ConditionalOnExpression(value="#{environment.getProperty('grpc.inProcessServerName','')!=''}")
    public GRpcServerRunner grpcInprocessServerRunner(@Qualifier(value="grpcInternalConfigurator") Consumer<ServerBuilder<?>> configurator) {
        return new GRpcServerRunner(configurator, (ServerBuilder<?>)InProcessServerBuilder.forName((String)this.grpcServerProperties.getInProcessServerName()));
    }

    @Bean
    public HealthStatusManager healthStatusManager() {
        return new HealthStatusManager();
    }

    @Bean
    @ConditionalOnMissingBean(value={GRpcServerBuilderConfigurer.class})
    public GRpcServerBuilderConfigurer serverBuilderConfigurer() {
        return new GRpcServerBuilderConfigurer();
    }

    @Bean(name={"grpcInternalConfigurator"})
    public Consumer<ServerBuilder<?>> configurator(GRpcServerBuilderConfigurer configurer) {
        return serverBuilder -> {
            if (this.grpcServerProperties.isEnabled()) {
                Optional.ofNullable(this.grpcServerProperties.getSecurity()).ifPresent(s -> {
                    boolean setupSecurity = Optional.ofNullable(s.getCertChain()).isPresent();
                    if (setupSecurity != Optional.ofNullable(s.getPrivateKey()).isPresent()) {
                        throw new BeanCreationException("Both  gRPC  TLS 'certChain' and 'privateKey' should be configured. One of them is null. ");
                    }
                    if (setupSecurity) {
                        try {
                            serverBuilder.useTransportSecurity(s.getCertChain().getInputStream(), s.getPrivateKey().getInputStream());
                        }
                        catch (IOException e) {
                            throw new BeanCreationException("Failed to setup security", (Throwable)e);
                        }
                    }
                });
            }
            configurer.configure((ServerBuilder<?>)serverBuilder);
        };
    }

    @Bean
    @ConfigurationPropertiesBinding
    public static Converter<String, InetSocketAddress> socketAddressConverter() {
        return new Converter<String, InetSocketAddress>(){

            public InetSocketAddress convert(String source) {
                int port;
                String[] chunks = source.split(":");
                switch (chunks.length) {
                    case 1: {
                        port = 6565;
                        break;
                    }
                    case 2: {
                        port = Integer.parseInt(chunks[1]);
                        if (port >= 1) break;
                        port = SocketUtils.findAvailableTcpPort();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(source + " can't be converted to socket address");
                    }
                }
                return new InetSocketAddress(chunks[0], port);
            }
        };
    }
}

