/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.security;

import io.grpc.BindableService;
import io.grpc.MethodDescriptor;
import io.grpc.ServerInterceptor;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.lognet.springboot.grpc.security.AuthenticatedConfigAttribute;
import org.lognet.springboot.grpc.security.GrpcSecurity;
import org.lognet.springboot.grpc.security.GrpcSecurityMetadataSource;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.annotation.Secured;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class GrpcServiceAuthorizationConfigurer
extends SecurityConfigurerAdapter<ServerInterceptor, GrpcSecurity> {
    private final Registry registry;

    public GrpcServiceAuthorizationConfigurer(ApplicationContext context) {
        this.registry = new Registry(context);
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void configure(GrpcSecurity builder) throws Exception {
        this.registry.processSecuredAnnotation();
        builder.setSharedObject(GrpcSecurityMetadataSource.class, new GrpcSecurityMetadataSource((Map<MethodDescriptor<?, ?>, List<ConfigAttribute>>)this.registry.securedMethods));
    }

    public class Registry {
        private MultiValueMap<MethodDescriptor<?, ?>, ConfigAttribute> securedMethods = new LinkedMultiValueMap();
        private ApplicationContext context;
        private boolean withSecuredAnnotation = true;

        Registry(ApplicationContext context) {
            this.context = context;
        }

        public AuthorizedMethod anyMethod() {
            ServiceDescriptor[] allServices = (ServiceDescriptor[])this.context.getBeansOfType(BindableService.class).values().stream().map(BindableService::bindService).map(ServerServiceDefinition::getServiceDescriptor).toArray(ServiceDescriptor[]::new);
            return new AuthorizedMethod(allServices);
        }

        public GrpcSecurity withoutSecuredAnnotation() {
            return this.withSecuredAnnotation(false);
        }

        public GrpcSecurity withSecuredAnnotation() {
            return this.withSecuredAnnotation(true);
        }

        public GrpcSecurity withSecuredAnnotation(boolean withSecuredAnnotation) {
            this.withSecuredAnnotation = withSecuredAnnotation;
            return this.and();
        }

        private void processSecuredAnnotation() {
            if (this.withSecuredAnnotation) {
                Collection services = this.context.getBeansOfType(BindableService.class).values();
                for (BindableService service : services) {
                    ServerServiceDefinition serverServiceDefinition = service.bindService();
                    Secured securedAnn = (Secured)AnnotationUtils.findAnnotation(service.getClass(), Secured.class);
                    if (null != securedAnn) {
                        new AuthorizedMethod(new ServiceDescriptor[]{serverServiceDefinition.getServiceDescriptor()}).hasAnyAuthority(securedAnn.value());
                    }
                    for (ServerMethodDefinition methodDefinition : serverServiceDefinition.getMethods()) {
                        Stream.of(service.getClass().getMethods()).filter(m -> m.getName().equalsIgnoreCase(methodDefinition.getMethodDescriptor().getBareMethodName())).findFirst().flatMap(m -> Optional.ofNullable((Secured)AnnotationUtils.findAnnotation((Method)m, Secured.class))).ifPresent(secured -> {
                            if (secured.value().length == 0) {
                                new AuthorizedMethod(new MethodDescriptor[]{methodDefinition.getMethodDescriptor()}).authenticated();
                            } else {
                                new AuthorizedMethod(new MethodDescriptor[]{methodDefinition.getMethodDescriptor()}).hasAnyAuthority(secured.value());
                            }
                        });
                    }
                }
            }
        }

        public AuthorizedMethod methods(MethodDescriptor<?, ?> ... methodDescriptor) {
            return new AuthorizedMethod((MethodDescriptor[])methodDescriptor);
        }

        public AuthorizedMethod services(ServiceDescriptor ... serviceDescriptor) {
            return new AuthorizedMethod(serviceDescriptor);
        }

        void map(List<MethodDescriptor<?, ?>> methods) {
            methods.forEach(m -> this.securedMethods.addAll(m, Collections.singletonList(new AuthenticatedConfigAttribute())));
        }

        void map(String attribute, List<MethodDescriptor<?, ?>> methods) {
            methods.forEach(m -> this.securedMethods.addAll(m, SecurityConfig.createList((String[])new String[]{attribute})));
        }

        public GrpcSecurity and() {
            return (GrpcSecurity)GrpcServiceAuthorizationConfigurer.this.and();
        }
    }

    public class AuthorizedMethod {
        private List<MethodDescriptor<?, ?>> methods;

        private AuthorizedMethod(MethodDescriptor<?, ?> ... methodDescriptor) {
            this.methods = Arrays.asList(methodDescriptor);
        }

        private AuthorizedMethod(ServiceDescriptor ... serviceDescriptor) {
            this.methods = Stream.of(serviceDescriptor).flatMap(s -> s.getMethods().stream()).collect(Collectors.toList());
        }

        public Registry authenticated() {
            GrpcServiceAuthorizationConfigurer.this.registry.map(this.methods);
            return GrpcServiceAuthorizationConfigurer.this.registry;
        }

        public Registry hasAnyRole(String ... roles) {
            String rolePrefix = "ROLE_";
            for (String role : roles) {
                if (!role.startsWith(rolePrefix)) continue;
                throw new IllegalArgumentException("role should not start with 'ROLE_' since it is automatically inserted. Got '" + role + "'");
            }
            return this.hasAnyAuthority((String[])Arrays.stream(roles).map(rolePrefix::concat).toArray(String[]::new));
        }

        public Registry hasAnyAuthority(String ... authorities) {
            for (String auth : authorities) {
                GrpcServiceAuthorizationConfigurer.this.registry.map(auth, this.methods);
            }
            return GrpcServiceAuthorizationConfigurer.this.registry;
        }
    }
}

