/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc;

import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import org.lognet.springboot.grpc.GRpcErrorHandler;

public interface FailureHandlingServerInterceptor
extends ServerInterceptor {
    default public void closeCall(Object o, GRpcErrorHandler errorHandler, ServerCall<?, ?> call, Metadata headers, Status status, Exception exception) {
        Metadata responseHeaders = new Metadata();
        Status statusToSend = errorHandler.handle(o, status, exception, headers, responseHeaders);
        call.close(statusToSend, responseHeaders);
    }

    public static class MessageBlockingServerCallListener<R>
    extends ForwardingServerCallListener.SimpleForwardingServerCallListener<R> {
        private volatile boolean messageBlocked = false;

        public MessageBlockingServerCallListener(ServerCall.Listener<R> delegate) {
            super(delegate);
        }

        public void onHalfClose() {
            if (!this.messageBlocked) {
                super.onHalfClose();
            }
        }

        protected void blockMessage() {
            this.messageBlocked = true;
        }
    }
}

