/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.autoconfigure;

import io.grpc.ServerBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.function.Consumer;
import org.lognet.springboot.grpc.GRpcServerBuilderConfigurer;
import org.lognet.springboot.grpc.GRpcServerRunner;
import org.lognet.springboot.grpc.GRpcService;
import org.lognet.springboot.grpc.autoconfigure.GRpcServerProperties;
import org.lognet.springboot.grpc.autoconfigure.GRpcValidationConfiguration;
import org.lognet.springboot.grpc.autoconfigure.NettyServerBuilderSelector;
import org.lognet.springboot.grpc.autoconfigure.OnGrpcServerEnabled;
import org.lognet.springboot.grpc.health.DefaultHealthStatusService;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.validation.ValidationAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.SocketUtils;

@AutoConfigureOrder
@AutoConfigureAfter(value={ValidationAutoConfiguration.class})
@ConditionalOnBean(annotation={GRpcService.class})
@EnableConfigurationProperties(value={GRpcServerProperties.class})
@Import(value={GRpcValidationConfiguration.class, NettyServerBuilderSelector.class, DefaultHealthStatusService.class})
public class GRpcAutoConfiguration {
    @Autowired
    private GRpcServerProperties grpcServerProperties;

    @Bean
    @OnGrpcServerEnabled
    public GRpcServerRunner grpcServerRunner(@Qualifier(value="grpcInternalConfigurator") Consumer<ServerBuilder<?>> configurator, ServerBuilder<?> serverBuilder) {
        return new GRpcServerRunner(configurator, serverBuilder);
    }

    @Bean
    @ConditionalOnProperty(prefix="grpc", name={"inProcessServerName"})
    public GRpcServerRunner grpcInprocessServerRunner(@Qualifier(value="grpcInternalConfigurator") Consumer<ServerBuilder<?>> configurator) {
        return new GRpcServerRunner(configurator, (ServerBuilder<?>)InProcessServerBuilder.forName((String)this.grpcServerProperties.getInProcessServerName()));
    }

    @Bean
    @ConditionalOnMissingBean(value={GRpcServerBuilderConfigurer.class})
    public GRpcServerBuilderConfigurer serverBuilderConfigurer() {
        return new GRpcServerBuilderConfigurer();
    }

    @Bean(name={"grpcInternalConfigurator"})
    public Consumer<ServerBuilder<?>> configurator(GRpcServerBuilderConfigurer configurer) {
        return serverBuilder -> {
            if (this.grpcServerProperties.isEnabled()) {
                Optional.ofNullable(this.grpcServerProperties.getSecurity()).ifPresent(s -> {
                    boolean setupSecurity = Optional.ofNullable(s.getCertChain()).isPresent();
                    if (setupSecurity != Optional.ofNullable(s.getPrivateKey()).isPresent()) {
                        throw new BeanCreationException("Both  gRPC  TLS 'certChain' and 'privateKey' should be configured. One of them is null. ");
                    }
                    if (setupSecurity) {
                        try {
                            serverBuilder.useTransportSecurity(s.getCertChain().getInputStream(), s.getPrivateKey().getInputStream());
                        }
                        catch (IOException e) {
                            throw new BeanCreationException("Failed to setup security", (Throwable)e);
                        }
                    }
                });
            }
            configurer.configure((ServerBuilder<?>)serverBuilder);
        };
    }

    @Bean
    @ConfigurationPropertiesBinding
    public static Converter<String, InetSocketAddress> socketAddressConverter() {
        return new Converter<String, InetSocketAddress>(){

            public InetSocketAddress convert(String source) {
                int port;
                String[] chunks = source.split(":");
                switch (chunks.length) {
                    case 1: {
                        port = 6565;
                        break;
                    }
                    case 2: {
                        port = Integer.parseInt(chunks[1]);
                        if (port >= 1) break;
                        port = SocketUtils.findAvailableTcpPort();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(source + " can't be converted to socket address");
                    }
                }
                return new InetSocketAddress(chunks[0], port);
            }
        };
    }
}

