/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.autoconfigure.consul;

import com.ecwid.consul.v1.agent.model.NewService;
import io.grpc.Server;
import io.grpc.ServerServiceDefinition;
import io.grpc.health.v1.HealthGrpc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.lognet.springboot.grpc.autoconfigure.GRpcServerProperties;
import org.lognet.springboot.grpc.autoconfigure.consul.ServiceRegistrationStrategy;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.serviceregistry.ConsulAutoRegistration;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public enum ServiceRegistrationMode implements ServiceRegistrationStrategy
{
    SINGLE_SERVER_WITH_GLOBAL_CHECK{

        @Override
        public Collection<NewService> createServices(Server grpcServer, ApplicationContext applicationContext) {
            GRpcServerProperties gRpcServerProperties = (GRpcServerProperties)applicationContext.getBean(GRpcServerProperties.class);
            ConsulDiscoveryProperties consulProperties = (ConsulDiscoveryProperties)applicationContext.getBean(ConsulDiscoveryProperties.class);
            NewService grpcService = new NewService();
            grpcService.setPort(Integer.valueOf(grpcServer.getPort()));
            if (!consulProperties.isPreferAgentAddress()) {
                grpcService.setAddress(consulProperties.getHostname());
            }
            String appName = "grpc-" + ConsulAutoRegistration.getAppName((ConsulDiscoveryProperties)consulProperties, (Environment)applicationContext.getEnvironment());
            grpcService.setName(ConsulAutoRegistration.normalizeForDns((String)appName));
            grpcService.setId("grpc-" + ConsulAutoRegistration.getInstanceId((ConsulDiscoveryProperties)consulProperties, (ApplicationContext)applicationContext));
            grpcService.setTags(consulProperties.getTags());
            if (consulProperties.isRegisterHealthCheck()) {
                NewService.Check healthCheck = new NewService.Check();
                healthCheck.setGrpc(consulProperties.getHostname() + ":" + grpcServer.getPort());
                healthCheck.setGrpcUseTLS(Boolean.valueOf(Objects.nonNull(gRpcServerProperties.getSecurity())));
                healthCheck.setInterval(consulProperties.getHealthCheckInterval());
                healthCheck.setTimeout(consulProperties.getHealthCheckTimeout());
                healthCheck.setDeregisterCriticalServiceAfter(consulProperties.getHealthCheckCriticalTimeout());
                grpcService.setCheck(healthCheck);
            }
            return Collections.singleton(grpcService);
        }
    }
    ,
    SINGLE_SERVER_WITH_CHECK_PER_SERVICE{

        @Override
        public Collection<NewService> createServices(Server grpcServer, ApplicationContext applicationContext) {
            NewService grpcService = SINGLE_SERVER_WITH_GLOBAL_CHECK.createServices(grpcServer, applicationContext).iterator().next();
            NewService.Check prototypeCheck = grpcService.getCheck();
            if (null != prototypeCheck) {
                grpcService.setCheck(null);
                grpcService.setChecks(grpcServer.getServices().stream().filter(d -> !d.getServiceDescriptor().equals(HealthGrpc.getServiceDescriptor())).map(d -> {
                    NewService.Check check = this.clone(prototypeCheck, NewService.Check.class);
                    check.setGrpc(String.format("%s/%s", check.getGrpc(), d.getServiceDescriptor().getName()));
                    return check;
                }).collect(Collectors.toList()));
            }
            return Collections.singleton(grpcService);
        }
    }
    ,
    STANDALONE_SERVICES{

        @Override
        public Collection<NewService> createServices(Server grpcServer, ApplicationContext applicationContext) {
            NewService grpcServicePrototype = SINGLE_SERVER_WITH_GLOBAL_CHECK.createServices(grpcServer, applicationContext).iterator().next();
            ArrayList<NewService> newServices = new ArrayList<NewService>();
            List services = grpcServer.getServices();
            for (int i = 0; i < services.size(); ++i) {
                ServerServiceDefinition d = (ServerServiceDefinition)services.get(i);
                if (d.getServiceDescriptor().equals(HealthGrpc.getServiceDescriptor())) continue;
                NewService service = this.clone(grpcServicePrototype, NewService.class);
                service.setId(String.format("%s-%d", service.getId(), i));
                service.getTags().add(d.getServiceDescriptor().getName());
                Optional.ofNullable(service.getCheck()).ifPresent(check -> check.setGrpc(String.format("%s/%s", check.getGrpc(), d.getServiceDescriptor().getName())));
                newServices.add(service);
            }
            return newServices;
        }
    };

}

