/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.autoconfigure.metrics;

import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.lognet.springboot.grpc.GRpcGlobalInterceptor;
import org.lognet.springboot.grpc.GRpcServerRunner;
import org.lognet.springboot.grpc.GRpcService;
import org.lognet.springboot.grpc.autoconfigure.GRpcAutoConfiguration;
import org.lognet.springboot.grpc.autoconfigure.GRpcServerProperties;
import org.lognet.springboot.grpc.autoconfigure.metrics.GRpcMetricsProperties;
import org.lognet.springboot.grpc.autoconfigure.metrics.GRpcMetricsTagsContributor;
import org.lognet.springboot.grpc.autoconfigure.metrics.RequestAwareGRpcMetricsTagsContributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.Ordered;

@Configuration
@AutoConfigureAfter(value={MetricsAutoConfiguration.class, CompositeMeterRegistryAutoConfiguration.class, GRpcAutoConfiguration.class})
@ConditionalOnClass(value={MeterRegistry.class})
@Conditional(value={OnGrpcAndMeterRegistryEnabledCondition.class})
@ConditionalOnBean(value={GRpcServerRunner.class})
@EnableConfigurationProperties(value={GRpcMetricsProperties.class})
public class GRpcMetricsAutoConfiguration {
    @Bean
    @GRpcGlobalInterceptor
    public ServerInterceptor measure(MeterRegistry registry, GRpcMetricsProperties metricsProperties) {
        return new MonitoringServerInterceptor(registry).order(metricsProperties.getInterceptorOrder());
    }

    @Bean
    public GRpcMetricsTagsContributor defaultTagsContributor(GRpcServerProperties properties) {
        boolean hasMultipleAddresses = Optional.ofNullable(properties.getNettyServer()).map(GRpcServerProperties.NettyServerProperties::getAdditionalListenAddresses).map(l -> !l.isEmpty()).orElse(false);
        GRpcMetricsTagsContributor defaultContributor = (status, methodDescriptor, attributes) -> Tags.of((String[])new String[]{"result", status.getCode().name(), "method", methodDescriptor.getFullMethodName()});
        if (hasMultipleAddresses) {
            return (status, methodDescriptor, attributes) -> {
                String address = Optional.ofNullable(attributes).map(a -> (SocketAddress)a.get(Grpc.TRANSPORT_ATTR_LOCAL_ADDR)).map(Object::toString).orElse("");
                return Tags.concat(defaultContributor.getTags(status, methodDescriptor, attributes), (String[])new String[]{"address", address});
            };
        }
        return defaultContributor;
    }

    static class MonitoringServerInterceptor
    implements ServerInterceptor,
    Ordered {
        private final MeterRegistry registry;
        private Collection<GRpcMetricsTagsContributor> tagsContributors;
        private Collection<RequestAwareGRpcMetricsTagsContributor<?>> requestAwareGRpcMetricsTagsContributors;
        private Integer order;

        @Autowired
        public void setTagsContributors(Collection<GRpcMetricsTagsContributor> tagsContributors) {
            this.tagsContributors = tagsContributors;
            this.requestAwareGRpcMetricsTagsContributors = tagsContributors.stream().filter(RequestAwareGRpcMetricsTagsContributor.class::isInstance).map(contributor -> (RequestAwareGRpcMetricsTagsContributor)contributor).collect(Collectors.toList());
        }

        public MonitoringServerInterceptor(MeterRegistry registry) {
            this.registry = registry;
        }

        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
            MonitoringServerCall<ReqT, RespT> monitoringServerCall = new MonitoringServerCall<ReqT, RespT>(call, this.registry, this.tagsContributors);
            ServerCall.Listener measuredCall = next.startCall(monitoringServerCall, headers);
            List<RequestAwareGRpcMetricsTagsContributor<?>> requestAwareContributorCandidates = this.requestAwareGRpcMetricsTagsContributors.stream().filter(contributor -> contributor.mightAccept(call.getMethodDescriptor())).collect(Collectors.toList());
            if (!requestAwareContributorCandidates.isEmpty()) {
                return new MessageMonitoringListener<ReqT>(measuredCall, monitoringServerCall, requestAwareContributorCandidates);
            }
            return measuredCall;
        }

        public int getOrder() {
            return Optional.ofNullable(this.order).orElse(-2147483628);
        }

        public MonitoringServerInterceptor order(Integer order) {
            this.order = order;
            return this;
        }
    }

    private static class MessageMonitoringListener<ReqT>
    extends ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT> {
        private static final Logger log = LoggerFactory.getLogger(MessageMonitoringListener.class);
        private final MonitoringServerCall<ReqT, ?> monitoringServerCall;
        private final Collection<RequestAwareGRpcMetricsTagsContributor<?>> requestAwareContributorCandidates;

        protected MessageMonitoringListener(ServerCall.Listener<ReqT> delegate, MonitoringServerCall<ReqT, ?> monitoringServerCall, Collection<RequestAwareGRpcMetricsTagsContributor<?>> requestAwareContributorCandidates) {
            super(delegate);
            this.monitoringServerCall = monitoringServerCall;
            this.requestAwareContributorCandidates = requestAwareContributorCandidates;
        }

        public void onMessage(ReqT message) {
            for (RequestAwareGRpcMetricsTagsContributor<?> contributor : this.requestAwareContributorCandidates) {
                if (!contributor.accepts(message)) continue;
                try {
                    this.monitoringServerCall.addTags(contributor.addTags(message, this.monitoringServerCall.getMethodDescriptor(), this.monitoringServerCall.getAttributes(), this.monitoringServerCall.getAdditionalTags()));
                }
                catch (RuntimeException error) {
                    log.error("Failed to  execute tag contributor {}", contributor, (Object)error);
                }
            }
            super.onMessage(message);
        }
    }

    static class MonitoringServerCall<ReqT, RespT>
    extends ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT> {
        private final MeterRegistry registry;
        final Timer.Sample start;
        private final Collection<GRpcMetricsTagsContributor> tagsContributors;
        private Tags additionalTags = Tags.empty();
        private volatile boolean closed = false;

        protected MonitoringServerCall(ServerCall<ReqT, RespT> delegate, MeterRegistry registry, Collection<GRpcMetricsTagsContributor> tagsContributors) {
            super(delegate);
            this.start = Timer.start((MeterRegistry)registry);
            this.registry = registry;
            this.tagsContributors = tagsContributors;
        }

        public void close(Status status, Metadata trailers) {
            if (!this.closed) {
                this.closed = true;
                Timer.Builder timerBuilder = Timer.builder((String)"grpc.server.calls");
                this.tagsContributors.forEach(c -> timerBuilder.tags(c.getTags(status, this.getMethodDescriptor(), this.getAttributes())));
                Optional.ofNullable(this.additionalTags).ifPresent(arg_0 -> ((Timer.Builder)timerBuilder).tags(arg_0));
                this.start.stop(timerBuilder.register(this.registry));
            }
            super.close(status, trailers);
        }

        public void addTags(Iterable<Tag> tags) {
            this.additionalTags = this.additionalTags.and(tags);
        }

        public Tags getAdditionalTags() {
            return this.additionalTags;
        }
    }

    protected static class OnGrpcAndMeterRegistryEnabledCondition
    extends AllNestedConditions {
        OnGrpcAndMeterRegistryEnabledCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(annotation={GRpcService.class})
        static class GrpcServiceCondition {
            GrpcServiceCondition() {
            }
        }

        @ConditionalOnBean(value={MeterRegistry.class})
        static class MeterRegistryCondition {
            MeterRegistryCondition() {
            }
        }
    }
}

