/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.security;

import io.grpc.ServerInterceptor;
import java.util.Collection;
import org.lognet.springboot.grpc.GRpcGlobalInterceptor;
import org.lognet.springboot.grpc.security.BasicAuthSchemeSelector;
import org.lognet.springboot.grpc.security.BearerTokenAuthSchemeSelector;
import org.lognet.springboot.grpc.security.GrpcSecurity;
import org.lognet.springboot.grpc.security.GrpcSecurityConfigurer;
import org.lognet.springboot.grpc.security.GrpcSecurityConfigurerAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.ObjectPostProcessor;

@Configuration
public class GrpcSecurityConfiguration {
    @Autowired
    private ConfigurableListableBeanFactory beanFactory;
    @Autowired
    private ObjectPostProcessor<Object> objectObjectPostProcessor;
    private Collection<GrpcSecurityConfigurer> grpcSecurityConfigurers;
    private GrpcSecurity grpcSecurity;

    @Bean
    @ConditionalOnMissingBean(value={GrpcSecurityConfigurerAdapter.class})
    public GrpcSecurityConfigurerAdapter defaultAdapter() {
        return new GrpcSecurityConfigurerAdapter(){};
    }

    @Bean
    @GRpcGlobalInterceptor
    public ServerInterceptor springGrpcSecurityInterceptor() throws Exception {
        boolean hasConfigurers;
        boolean bl = hasConfigurers = this.grpcSecurityConfigurers != null && !this.grpcSecurityConfigurers.isEmpty();
        if (!hasConfigurers) {
            GrpcSecurityConfigurerAdapter adapter = (GrpcSecurityConfigurerAdapter)((Object)this.objectObjectPostProcessor.postProcess((Object)new GrpcSecurityConfigurerAdapter(){}));
            this.grpcSecurity.apply(adapter);
        }
        return (ServerInterceptor)this.grpcSecurity.build();
    }

    @Bean
    public BasicAuthSchemeSelector basicAuthSchemeSelector() {
        return new BasicAuthSchemeSelector();
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken", "org.springframework.security.oauth2.core.OAuth2AuthenticationException"})
    public BearerTokenAuthSchemeSelector bearerTokenAuthSchemeSelector() {
        return new BearerTokenAuthSchemeSelector();
    }

    @Autowired(required=false)
    public void setFilterChainProxySecurityConfigurer(ObjectPostProcessor<Object> objectPostProcessor) throws Exception {
        this.grpcSecurity = (GrpcSecurity)((Object)objectPostProcessor.postProcess((Object)new GrpcSecurity(objectPostProcessor)));
        this.grpcSecurityConfigurers = this.beanFactory.getBeansOfType(GrpcSecurityConfigurer.class).values();
        for (GrpcSecurityConfigurer configurer : this.grpcSecurityConfigurers) {
            this.grpcSecurity.apply(configurer);
        }
    }
}

