/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.security;

import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.Status;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.lognet.springboot.grpc.FailureHandlingServerInterceptor;
import org.lognet.springboot.grpc.GRpcErrorHandler;
import org.lognet.springboot.grpc.autoconfigure.GRpcServerProperties;
import org.lognet.springboot.grpc.security.AuthenticationSchemeSelector;
import org.lognet.springboot.grpc.security.GrpcSecurity;
import org.lognet.springboot.grpc.security.GrpcSecurityMetadataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.intercept.AbstractSecurityInterceptor;
import org.springframework.security.access.intercept.InterceptorStatusToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecurityInterceptor
extends AbstractSecurityInterceptor
implements FailureHandlingServerInterceptor,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(SecurityInterceptor.class);
    private static final Context.Key<InterceptorStatusToken> INTERCEPTOR_STATUS_TOKEN = Context.key((String)"INTERCEPTOR_STATUS_TOKEN");
    private final GrpcSecurityMetadataSource securedMethods;
    private final AuthenticationSchemeSelector schemeSelector;
    private GRpcServerProperties.SecurityProperties.Auth authCfg;
    private GRpcErrorHandler errorHandler;

    public SecurityInterceptor(GrpcSecurityMetadataSource securedMethods, AuthenticationSchemeSelector schemeSelector) {
        this.securedMethods = securedMethods;
        this.schemeSelector = schemeSelector;
    }

    @Autowired
    public void setErrorHandler(Optional<GRpcErrorHandler> errorHandler) {
        this.errorHandler = errorHandler.orElseGet(() -> new GRpcErrorHandler(){});
    }

    public void setConfig(GRpcServerProperties.SecurityProperties.Auth authCfg) {
        this.authCfg = Optional.ofNullable(authCfg).orElseGet(GRpcServerProperties.SecurityProperties.Auth::new);
    }

    public int getOrder() {
        return Optional.ofNullable(this.authCfg.getInterceptorOrder()).orElse(-2147483647);
    }

    public Class<?> getSecureObjectClass() {
        return MethodDescriptor.class;
    }

    public GrpcSecurityMetadataSource obtainSecurityMetadataSource() {
        return this.securedMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        CharSequence authorization = Optional.ofNullable((byte[])headers.get(Metadata.Key.of((String)"Authorization-bin", (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER))).map(auth -> StandardCharsets.UTF_8.decode(ByteBuffer.wrap(auth))).orElse((CharSequence)headers.get(Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER)));
        try {
            Context grpcSecurityContext;
            try {
                grpcSecurityContext = this.setupGRpcSecurityContext(call, authorization);
            }
            catch (AccessDeniedException e) {
                ServerCall.Listener<ReqT> listener = this.fail(next, call, headers, Status.PERMISSION_DENIED, (Exception)((Object)e));
                SecurityContextHolder.getContext().setAuthentication(null);
                return listener;
            }
            catch (Exception e) {
                ServerCall.Listener<ReqT> listener = this.fail(next, call, headers, Status.UNAUTHENTICATED, e);
                SecurityContextHolder.getContext().setAuthentication(null);
                return listener;
            }
            ServerCall.Listener listener = Contexts.interceptCall((Context)grpcSecurityContext, call, (Metadata)headers, this.authenticationPropagatingHandler(next));
            return listener;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(null);
        }
    }

    private <ReqT, RespT> ServerCallHandler<ReqT, RespT> authenticationPropagatingHandler(ServerCallHandler<ReqT, RespT> next) {
        return (call, headers) -> new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(next.startCall(this.afterInvocationPropagator(call), headers)){

            public void onMessage(ReqT message) {
                this.propagateAuthentication(() -> super.onMessage(message));
            }

            public void onHalfClose() {
                try {
                    this.propagateAuthentication(() -> super.onHalfClose());
                }
                finally {
                    SecurityInterceptor.this.finallyInvocation((InterceptorStatusToken)INTERCEPTOR_STATUS_TOKEN.get());
                }
            }

            public void onCancel() {
                this.propagateAuthentication(() -> super.onCancel());
            }

            public void onComplete() {
                this.propagateAuthentication(() -> super.onComplete());
            }

            public void onReady() {
                this.propagateAuthentication(() -> super.onReady());
            }

            private void propagateAuthentication(Runnable runnable) {
                try {
                    SecurityContextHolder.getContext().setAuthentication((Authentication)GrpcSecurity.AUTHENTICATION_CONTEXT_KEY.get());
                    runnable.run();
                }
                finally {
                    SecurityContextHolder.clearContext();
                }
            }
        };
    }

    private <RespT, ReqT> ServerCall<RespT, ReqT> afterInvocationPropagator(ServerCall<RespT, ReqT> call) {
        return new ForwardingServerCall.SimpleForwardingServerCall<RespT, ReqT>(call){

            public void sendMessage(ReqT message) {
                super.sendMessage(SecurityInterceptor.this.afterInvocation((InterceptorStatusToken)INTERCEPTOR_STATUS_TOKEN.get(), message));
            }
        };
    }

    private Context setupGRpcSecurityContext(ServerCall<?, ?> call, CharSequence authorization) {
        Authentication authentication = null == authorization ? null : this.schemeSelector.getAuthScheme(authorization).orElseThrow(() -> new RuntimeException("Can't get authentication from authorization header"));
        SecurityContext context = SecurityContextHolder.createEmptyContext();
        context.setAuthentication(authentication);
        SecurityContextHolder.setContext((SecurityContext)context);
        InterceptorStatusToken interceptorStatusToken = this.beforeInvocation(call.getMethodDescriptor());
        return Context.current().withValues(GrpcSecurity.AUTHENTICATION_CONTEXT_KEY, (Object)SecurityContextHolder.getContext().getAuthentication(), INTERCEPTOR_STATUS_TOKEN, (Object)interceptorStatusToken);
    }

    private <RespT, ReqT> ServerCall.Listener<ReqT> fail(ServerCallHandler<ReqT, RespT> next, final ServerCall<ReqT, RespT> call, final Metadata headers, final Status status, final Exception exception) {
        if (this.authCfg.isFailFast()) {
            this.closeCall(null, this.errorHandler, call, headers, status, exception);
            return new ServerCall.Listener<ReqT>(){};
        }
        return new FailureHandlingServerInterceptor.MessageBlockingServerCallListener<ReqT>(next.startCall(call, headers)){

            public void onMessage(ReqT message) {
                this.blockMessage();
                SecurityInterceptor.this.closeCall(message, SecurityInterceptor.this.errorHandler, call, headers, status, exception);
            }
        };
    }
}

