// Generated by delombok at Sun Jan 23 12:28:22 UTC 2022
package org.lognet.springboot.grpc.recovery;

import io.grpc.Status;
import java.util.Optional;
import org.lognet.springboot.grpc.GRpcErrorHandler;

public class ErrorHandlerAdapter {
  @java.lang.SuppressWarnings("all")
  private static final org.slf4j.Logger log =
      org.slf4j.LoggerFactory.getLogger(ErrorHandlerAdapter.class);

  private final Optional<GRpcErrorHandler> errorHandler;

  public ErrorHandlerAdapter(Optional<GRpcErrorHandler> errorHandler) {
    this.errorHandler = errorHandler;
  }

  protected Status handle(Exception e, Status status, GRpcExceptionScope scope) {
    if (errorHandler.isPresent()) {
      return errorHandler
          .get()
          .handle(
              scope.getRequestOrResponse(),
              status,
              e,
              scope.getCallHeaders(),
              scope.getResponseHeaders());
    } else {
      log.error("Got error with status {} ", status.getCode().name(), e);
      return status.withDescription(e.getMessage());
    }
  }
}
