// Generated by delombok at Sun Jan 23 12:28:22 UTC 2022
package org.lognet.springboot.grpc.recovery;

import java.util.Optional;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

/**
 * Runtime exception that allows to wrap the checked exception to be handled by {@link
 * GRpcExceptionHandler}
 */
public final class GRpcRuntimeExceptionWrapper extends RuntimeException {
  private Object hint;

  public GRpcRuntimeExceptionWrapper(@NonNull Throwable cause, Object hint) {
    this(cause);
    this.hint = hint;
  }

  public GRpcRuntimeExceptionWrapper(@NonNull Throwable cause) {
    super(null, cause);
    Assert.notNull(cause, () -> "Cause can\'t be null");
  }

  public static Throwable unwrap(Throwable exc) {
    return Optional.ofNullable(exc)
        .filter(GRpcRuntimeExceptionWrapper.class::isInstance)
        .map(Throwable::getCause)
        .orElse(exc);
  }

  public static Object getHint(Throwable exc) {
    return Optional.ofNullable(exc)
        .filter(GRpcRuntimeExceptionWrapper.class::isInstance)
        .map(GRpcRuntimeExceptionWrapper.class::cast)
        .map(w -> w.getHint())
        .orElse(null);
  }

  @java.lang.SuppressWarnings("all")
  public Object getHint() {
    return this.hint;
  }
}
