/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.recovery;

import io.grpc.BindableService;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.lognet.springboot.grpc.GRpcServicesRegistry;
import org.lognet.springboot.grpc.recovery.GRpcExceptionHandler;
import org.lognet.springboot.grpc.recovery.GRpcRuntimeExceptionWrapper;
import org.lognet.springboot.grpc.recovery.GRpcServiceAdvice;
import org.lognet.springboot.grpc.recovery.HandlerMethod;
import org.springframework.core.ExceptionDepthComparator;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;

public class GRpcExceptionHandlerMethodResolver {
    private final Map<Class<? extends Throwable>, HandlerMethod> mappedHandlers = new HashMap<Class<? extends Throwable>, HandlerMethod>(16);
    private final Map<Class<? extends Throwable>, HandlerMethod> exceptionLookupCache = new ConcurrentReferenceHashMap(16);
    private Map<String, GRpcExceptionHandlerMethodResolver> privateResolvers;

    public GRpcExceptionHandlerMethodResolver(GRpcServicesRegistry registry, Collection<Object> advices) {
        this(advices);
        this.privateResolvers = registry.getServiceNameToServiceBeanMap().entrySet().stream().peek(e -> {
            if (null != AnnotationUtils.findAnnotation(((BindableService)e.getValue()).getClass(), GRpcServiceAdvice.class)) {
                throw new IllegalStateException(String.format("Service %s should NOT be annotated with %s", ((BindableService)e.getValue()).getClass().getName(), GRpcServiceAdvice.class.getName()));
            }
        }).collect(Collectors.toMap(Map.Entry::getKey, e -> new GRpcExceptionHandlerMethodResolver(Collections.singleton(e.getValue()))));
    }

    public boolean hasErrorHandlers() {
        return !this.mappedHandlers.isEmpty();
    }

    private GRpcExceptionHandlerMethodResolver(Collection<Object> advices) {
        ReflectionUtils.MethodFilter f = method -> AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, GRpcExceptionHandler.class);
        for (Object advice : advices) {
            for (Method method2 : MethodIntrospector.selectMethods(advice.getClass(), (ReflectionUtils.MethodFilter)f)) {
                HandlerMethod handlerMethod = HandlerMethod.create(advice, method2);
                Class<? extends Throwable> exceptionType = handlerMethod.getExceptionType();
                HandlerMethod oldHandler = this.mappedHandlers.put(exceptionType, handlerMethod);
                if (null == oldHandler) continue;
                throw new IllegalStateException("Ambiguous @GRpcExceptionHandler method mapped for [" + exceptionType + "]: {" + oldHandler.getMethod() + ", " + handlerMethod.getMethod() + "}");
            }
        }
    }

    public Optional<HandlerMethod> resolveMethodByThrowable(String grpcServiceName, Throwable exc) {
        if (null == exc) {
            return Optional.empty();
        }
        Throwable exception = GRpcRuntimeExceptionWrapper.unwrap(exc);
        Optional<HandlerMethod> method = Optional.ofNullable(this.privateResolvers).map(r -> (GRpcExceptionHandlerMethodResolver)r.get(grpcServiceName)).flatMap(r -> r.resolveMethodByThrowable(grpcServiceName, exception));
        if (method.isPresent()) {
            return method;
        }
        method = this.resolveMethodByExceptionType(exception.getClass());
        if (method.isPresent()) {
            return method;
        }
        Throwable cause = exception.getCause();
        if (cause != null) {
            method = this.resolveMethodByThrowable(grpcServiceName, cause);
        }
        return method;
    }

    private Optional<HandlerMethod> resolveMethodByExceptionType(Class<? extends Throwable> exceptionType) {
        HandlerMethod method = this.exceptionLookupCache.get(exceptionType);
        if (null != method) {
            return Optional.of(method);
        }
        method = this.getMappedMethod(exceptionType);
        if (null != method) {
            this.exceptionLookupCache.put(exceptionType, method);
            return Optional.of(method);
        }
        return Optional.empty();
    }

    private HandlerMethod getMappedMethod(Class<? extends Throwable> exceptionType) {
        ArrayList<Class<? extends Throwable>> matches = new ArrayList<Class<? extends Throwable>>();
        for (Class<? extends Throwable> mappedException : this.mappedHandlers.keySet()) {
            if (!mappedException.isAssignableFrom(exceptionType)) continue;
            matches.add(mappedException);
        }
        if (!matches.isEmpty()) {
            if (matches.size() > 1) {
                matches.sort((Comparator<Class<? extends Throwable>>)new ExceptionDepthComparator(exceptionType));
            }
            return this.mappedHandlers.get(matches.get(0));
        }
        return null;
    }
}

