/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.security;

import io.grpc.BindableService;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import java.util.Collection;
import java.util.Optional;
import org.lognet.springboot.grpc.GRpcErrorHandler;
import org.lognet.springboot.grpc.GRpcGlobalInterceptor;
import org.lognet.springboot.grpc.autoconfigure.ConditionalOnMissingErrorHandler;
import org.lognet.springboot.grpc.recovery.ErrorHandlerAdapter;
import org.lognet.springboot.grpc.recovery.GRpcExceptionHandler;
import org.lognet.springboot.grpc.recovery.GRpcExceptionScope;
import org.lognet.springboot.grpc.recovery.GRpcServiceAdvice;
import org.lognet.springboot.grpc.security.BasicAuthSchemeSelector;
import org.lognet.springboot.grpc.security.BearerTokenAuthSchemeSelector;
import org.lognet.springboot.grpc.security.GrpcSecurity;
import org.lognet.springboot.grpc.security.GrpcSecurityConfigurer;
import org.lognet.springboot.grpc.security.GrpcSecurityConfigurerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.intercept.aopalliance.MethodSecurityInterceptor;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.core.AuthenticationException;

@Configuration
public class GrpcSecurityConfiguration {
    @Autowired
    private ConfigurableListableBeanFactory beanFactory;
    @Autowired
    private ObjectPostProcessor<Object> objectObjectPostProcessor;
    private Collection<GrpcSecurityConfigurer> grpcSecurityConfigurers;
    private GrpcSecurity grpcSecurity;

    @Bean
    public static BeanPostProcessor bypassMethodInterceptorForGrpcMethodInvocation() {
        return new BeanPostProcessor(){

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof MethodSecurityInterceptor) {
                    return invocation -> {
                        if (BindableService.class.isAssignableFrom(invocation.getMethod().getDeclaringClass())) {
                            return invocation.proceed();
                        }
                        return ((MethodSecurityInterceptor)bean).invoke(invocation);
                    };
                }
                return bean;
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(value={GrpcSecurityConfigurerAdapter.class})
    public GrpcSecurityConfigurerAdapter defaultAdapter() {
        return new GrpcSecurityConfigurerAdapter(){};
    }

    @Bean
    @GRpcGlobalInterceptor
    public ServerInterceptor springGrpcSecurityInterceptor() throws Exception {
        boolean hasConfigurers;
        boolean bl = hasConfigurers = this.grpcSecurityConfigurers != null && !this.grpcSecurityConfigurers.isEmpty();
        if (!hasConfigurers) {
            GrpcSecurityConfigurerAdapter adapter = (GrpcSecurityConfigurerAdapter)((Object)this.objectObjectPostProcessor.postProcess((Object)new GrpcSecurityConfigurerAdapter(){}));
            this.grpcSecurity.apply(adapter);
        }
        return (ServerInterceptor)this.grpcSecurity.build();
    }

    @Bean
    public BasicAuthSchemeSelector basicAuthSchemeSelector() {
        return new BasicAuthSchemeSelector();
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken", "org.springframework.security.oauth2.core.OAuth2AuthenticationException"})
    public BearerTokenAuthSchemeSelector bearerTokenAuthSchemeSelector() {
        return new BearerTokenAuthSchemeSelector();
    }

    @Autowired(required=false)
    public void setFilterChainProxySecurityConfigurer(ObjectPostProcessor<Object> objectPostProcessor) throws Exception {
        this.grpcSecurity = (GrpcSecurity)((Object)objectPostProcessor.postProcess((Object)new GrpcSecurity(objectPostProcessor)));
        this.grpcSecurityConfigurers = this.beanFactory.getBeansOfType(GrpcSecurityConfigurer.class).values();
        for (GrpcSecurityConfigurer configurer : this.grpcSecurityConfigurers) {
            this.grpcSecurity.apply(configurer);
        }
    }

    @ConditionalOnMissingErrorHandler(value=AuthenticationException.class)
    @Configuration
    static class DefaultAuthErrorHandlerConfig {
        DefaultAuthErrorHandlerConfig() {
        }

        @GRpcServiceAdvice
        public static class DefaultAuthErrorHandler
        extends ErrorHandlerAdapter {
            private static final Logger log = LoggerFactory.getLogger(DefaultAuthErrorHandler.class);

            public DefaultAuthErrorHandler(Optional<GRpcErrorHandler> errorHandler) {
                super(errorHandler);
            }

            @GRpcExceptionHandler
            public Status handle(AuthenticationException e, GRpcExceptionScope scope) {
                return this.handle((Exception)e, Status.UNAUTHENTICATED, scope);
            }
        }
    }

    @ConditionalOnMissingErrorHandler(value=AccessDeniedException.class)
    @Configuration
    static class DefaultAccessDeniedErrorHandlerConfig {
        DefaultAccessDeniedErrorHandlerConfig() {
        }

        @GRpcServiceAdvice
        public static class DefaultAccessDeniedErrorHandler
        extends ErrorHandlerAdapter {
            private static final Logger log = LoggerFactory.getLogger(DefaultAccessDeniedErrorHandler.class);

            public DefaultAccessDeniedErrorHandler(Optional<GRpcErrorHandler> errorHandler) {
                super(errorHandler);
            }

            @GRpcExceptionHandler
            public Status handle(AccessDeniedException e, GRpcExceptionScope scope) {
                return this.handle((Exception)e, Status.PERMISSION_DENIED, scope);
            }
        }
    }
}

