/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.autoconfigure.actuate;

import io.grpc.BindableService;
import io.grpc.ServiceDescriptor;
import io.grpc.health.v1.HealthCheckResponse;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.lognet.springboot.grpc.GRpcService;
import org.lognet.springboot.grpc.GRpcServicesRegistry;
import org.lognet.springboot.grpc.autoconfigure.GRpcAutoConfiguration;
import org.lognet.springboot.grpc.autoconfigure.OnGrpcServerEnabled;
import org.lognet.springboot.grpc.context.LocalRunningGrpcPort;
import org.lognet.springboot.grpc.health.ManagedHealthStatusService;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.CompositeHealthContributor;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnClass(value={HealthContributor.class})
@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={GRpcAutoConfiguration.class})
@ConditionalOnBean(annotation={GRpcService.class})
@OnGrpcServerEnabled
public class GRpcActuateAutoConfiguration {

    @Endpoint(id="grpc")
    static class GrpcEndpoint {
        private final GRpcServicesRegistry registry;
        private int port;

        public GrpcEndpoint(GRpcServicesRegistry registry, int port) {
            this.registry = registry;
            this.port = port;
        }

        @ReadOperation
        public GRpcServices services() {
            return new GRpcServices(this.registry.getBeanNameToServiceBeanMap(), this.port);
        }

        public static final class GRpcServices {
            private final List<GrpcService> services;
            int port;

            private GRpcServices(Map<String, BindableService> services, int port) {
                this.port = port;
                this.services = services.values().stream().map(s -> {
                    ServiceDescriptor serviceDescriptor = s.bindService().getServiceDescriptor();
                    return GrpcService.builder().name(serviceDescriptor.getName()).methods(serviceDescriptor.getMethods().stream().map(m -> GrpcMethod.builder().name(m.getBareMethodName()).build()).collect(Collectors.toList())).build();
                }).collect(Collectors.toList());
            }

            public List<GrpcService> getServices() {
                return this.services;
            }

            public int getPort() {
                return this.port;
            }

            static class GrpcMethod {
                private String name;

                GrpcMethod(String name) {
                    this.name = name;
                }

                public static GrpcMethodBuilder builder() {
                    return new GrpcMethodBuilder();
                }

                public String getName() {
                    return this.name;
                }

                public static class GrpcMethodBuilder {
                    private String name;

                    GrpcMethodBuilder() {
                    }

                    public GrpcMethodBuilder name(String name) {
                        this.name = name;
                        return this;
                    }

                    public GrpcMethod build() {
                        return new GrpcMethod(this.name);
                    }

                    public String toString() {
                        return "GRpcActuateAutoConfiguration.GrpcEndpoint.GRpcServices.GrpcMethod.GrpcMethodBuilder(name=" + this.name + ")";
                    }
                }
            }

            static class GrpcService {
                private String name;
                private List<GrpcMethod> methods;

                GrpcService(String name, List<GrpcMethod> methods) {
                    this.name = name;
                    this.methods = methods;
                }

                public static GrpcServiceBuilder builder() {
                    return new GrpcServiceBuilder();
                }

                public String getName() {
                    return this.name;
                }

                public List<GrpcMethod> getMethods() {
                    return this.methods;
                }

                public static class GrpcServiceBuilder {
                    private String name;
                    private List<GrpcMethod> methods;

                    GrpcServiceBuilder() {
                    }

                    public GrpcServiceBuilder name(String name) {
                        this.name = name;
                        return this;
                    }

                    public GrpcServiceBuilder methods(List<GrpcMethod> methods) {
                        this.methods = methods;
                        return this;
                    }

                    public GrpcService build() {
                        return new GrpcService(this.name, this.methods);
                    }

                    public String toString() {
                        return "GRpcActuateAutoConfiguration.GrpcEndpoint.GRpcServices.GrpcService.GrpcServiceBuilder(name=" + this.name + ", methods=" + this.methods + ")";
                    }
                }
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnAvailableEndpoint(endpoint=GrpcEndpoint.class)
    static class GrpcEndpointConfiguration {
        GrpcEndpointConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public GrpcEndpoint grpcEndpoint(GRpcServicesRegistry registry, @LocalRunningGrpcPort int port) {
            return new GrpcEndpoint(registry, port);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnEnabledHealthIndicator(value="grpc")
    static class GRpcHealthHealthContributorConfiguration {
        GRpcHealthHealthContributorConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"grpcHealthIndicator"})
        public HealthContributor grpcHealthIndicator(GRpcServicesRegistry registry, final ManagedHealthStatusService healthStatusService) {
            Map services = registry.getServiceNameToServiceBeanMap().keySet().stream().filter(s -> !"grpc.health.v1.Health".equals(s)).collect(Collectors.toMap(Function.identity(), s -> new AbstractHealthIndicator((String)s){
                final /* synthetic */ String val$s;
                {
                    this.val$s = string;
                }

                protected void doHealthCheck(Health.Builder builder) throws Exception {
                    HealthCheckResponse.ServingStatus status = healthStatusService.statuses().get(this.val$s);
                    if (null == status) {
                        builder.unknown();
                        return;
                    }
                    switch (status) {
                        case SERVING: {
                            builder.up();
                            break;
                        }
                        case NOT_SERVING: {
                            builder.down();
                            break;
                        }
                        case UNKNOWN: 
                        case UNRECOGNIZED: {
                            builder.unknown();
                            break;
                        }
                        case SERVICE_UNKNOWN: {
                            builder.outOfService();
                        }
                    }
                }
            }));
            return CompositeHealthContributor.fromMap(services);
        }
    }
}

