/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.Status;
import java.util.Optional;
import java.util.function.Consumer;
import org.lognet.springboot.grpc.recovery.GRpcExceptionHandlerMethodResolver;
import org.lognet.springboot.grpc.recovery.GRpcExceptionScope;
import org.lognet.springboot.grpc.recovery.GRpcRuntimeExceptionWrapper;
import org.lognet.springboot.grpc.recovery.HandlerMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailureHandlingSupport {
    private static final Logger log = LoggerFactory.getLogger(FailureHandlingSupport.class);
    private final GRpcExceptionHandlerMethodResolver methodResolver;

    public FailureHandlingSupport(GRpcExceptionHandlerMethodResolver methodResolver) {
        this.methodResolver = methodResolver;
    }

    public void closeCall(RuntimeException e, ServerCall<?, ?> call, Metadata headers) throws RuntimeException {
        this.closeCall(e, call, headers, null);
    }

    public void closeCall(RuntimeException e, ServerCall<?, ?> call, Metadata headers, Consumer<GRpcExceptionScope.GRpcExceptionScopeBuilder> customizer) throws RuntimeException {
        Status statusToSend = Status.INTERNAL;
        Metadata metadataToSend = null;
        Optional<HandlerMethod> handlerMethod = this.methodResolver.resolveMethodByThrowable(call.getMethodDescriptor().getServiceName(), e);
        if (handlerMethod.isPresent()) {
            GRpcExceptionScope.GRpcExceptionScopeBuilder exceptionScopeBuilder = GRpcExceptionScope.builder().callHeaders(headers).methodCallAttributes(call.getAttributes()).methodDescriptor(call.getMethodDescriptor()).hint(GRpcRuntimeExceptionWrapper.getHint(e));
            Optional.ofNullable(customizer).ifPresent(c -> c.accept(exceptionScopeBuilder));
            GRpcExceptionScope excScope = exceptionScopeBuilder.build();
            HandlerMethod handler = handlerMethod.get();
            try {
                statusToSend = handler.invoke(GRpcRuntimeExceptionWrapper.unwrap(e), excScope);
                metadataToSend = excScope.getResponseHeaders();
            }
            catch (Exception handlerException) {
                LoggerFactory.getLogger(this.getClass()).error("Caught exception while executing handler method {}, returning {} status.", new Object[]{handler.getMethod(), statusToSend, handlerException});
            }
        }
        log.warn("Closing call with {}", (Object)statusToSend, (Object)GRpcRuntimeExceptionWrapper.unwrap(e));
        call.close(statusToSend, Optional.ofNullable(metadataToSend).orElseGet(Metadata::new));
    }
}

