// Generated by delombok at Wed May 24 13:15:31 UTC 2023
package org.lognet.springboot.grpc.autoconfigure.actuate;

import io.grpc.BindableService;
import io.grpc.ServiceDescriptor;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.health.v1.HealthGrpc;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.lognet.springboot.grpc.GRpcService;
import org.lognet.springboot.grpc.GRpcServicesRegistry;
import org.lognet.springboot.grpc.autoconfigure.GRpcAutoConfiguration;
import org.lognet.springboot.grpc.autoconfigure.OnGrpcServerEnabled;
import org.lognet.springboot.grpc.context.GRpcServerInitializedEvent;
import org.lognet.springboot.grpc.health.ManagedHealthStatusService;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.CompositeHealthContributor;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

@ConditionalOnClass(HealthContributor.class)
@Configuration(proxyBeanMethods = false)
@AutoConfigureAfter(GRpcAutoConfiguration.class)
@ConditionalOnBean(annotation = GRpcService.class)
@OnGrpcServerEnabled
public class GRpcActuateAutoConfiguration {

  @Configuration(proxyBeanMethods = false)
  @ConditionalOnEnabledHealthIndicator("grpc")
  static class GRpcHealthHealthContributorConfiguration {
    @Bean
    @ConditionalOnMissingBean(name = "grpcHealthIndicator")
    public HealthContributor grpcHealthIndicator(
        GRpcServicesRegistry registry, ManagedHealthStatusService healthStatusService) {
      final Map<String, HealthIndicator> services =
          registry.getServiceNameToServiceBeanMap().keySet().stream()
              .filter(s -> !HealthGrpc.SERVICE_NAME.equals(s))
              .collect(
                  Collectors.toMap(
                      Function.identity(),
                      s ->
                          new AbstractHealthIndicator() {
                            @Override
                            protected void doHealthCheck(Health.Builder builder) throws Exception {
                              final HealthCheckResponse.ServingStatus status =
                                  healthStatusService.statuses().get(s);
                              if (null == status) {
                                builder.unknown();
                                return;
                              }
                              switch (status) {
                                case SERVING:
                                  builder.up();
                                  break;
                                case NOT_SERVING:
                                  builder.down();
                                  break;
                                case UNKNOWN:
                                case UNRECOGNIZED:
                                  builder.unknown();
                                  break;
                                case SERVICE_UNKNOWN:
                                  builder.outOfService();
                                  break;
                              }
                            }
                          }));
      return CompositeHealthContributor.fromMap(services);
    }
  }

  @Configuration(proxyBeanMethods = false)
  @ConditionalOnAvailableEndpoint(endpoint = GrpcEndpoint.class)
  static class GrpcEndpointConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public GrpcEndpoint grpcEndpoint(GRpcServicesRegistry registry) {
      return new GrpcEndpoint(registry);
    }
  }

  @Endpoint(id = "grpc")
  static class GrpcEndpoint {

    public static final class GRpcServices {

      static class GrpcService {
        private String name;
        private List<GrpcMethod> methods;

        @java.lang.SuppressWarnings("all")
        GrpcService(final String name, final List<GrpcMethod> methods) {
          this.name = name;
          this.methods = methods;
        }

        @java.lang.SuppressWarnings("all")
        public static class GrpcServiceBuilder {
          @java.lang.SuppressWarnings("all")
          private String name;

          @java.lang.SuppressWarnings("all")
          private List<GrpcMethod> methods;

          @java.lang.SuppressWarnings("all")
          GrpcServiceBuilder() {}

          /**
           * @return {@code this}.
           */
          @java.lang.SuppressWarnings("all")
          public GRpcActuateAutoConfiguration.GrpcEndpoint.GRpcServices.GrpcService
                  .GrpcServiceBuilder
              name(final String name) {
            this.name = name;
            return this;
          }

          /**
           * @return {@code this}.
           */
          @java.lang.SuppressWarnings("all")
          public GRpcActuateAutoConfiguration.GrpcEndpoint.GRpcServices.GrpcService
                  .GrpcServiceBuilder
              methods(final List<GrpcMethod> methods) {
            this.methods = methods;
            return this;
          }

          @java.lang.SuppressWarnings("all")
          public GRpcActuateAutoConfiguration.GrpcEndpoint.GRpcServices.GrpcService build() {
            return new GRpcActuateAutoConfiguration.GrpcEndpoint.GRpcServices.GrpcService(
                this.name, this.methods);
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          public java.lang.String toString() {
            return "GRpcActuateAutoConfiguration.GrpcEndpoint.GRpcServices.GrpcService.GrpcServiceBuilder(name="
                + this.name
                + ", methods="
                + this.methods
                + ")";
          }
        }

        @java.lang.SuppressWarnings("all")
        public static GRpcActuateAutoConfiguration.GrpcEndpoint.GRpcServices.GrpcService
                .GrpcServiceBuilder
            builder() {
          return new GRpcActuateAutoConfiguration.GrpcEndpoint.GRpcServices.GrpcService
              .GrpcServiceBuilder();
        }

        @java.lang.SuppressWarnings("all")
        public String getName() {
          return this.name;
        }

        @java.lang.SuppressWarnings("all")
        public List<GrpcMethod> getMethods() {
          return this.methods;
        }
      }

      static class GrpcMethod {
        private String name;

        @java.lang.SuppressWarnings("all")
        GrpcMethod(final String name) {
          this.name = name;
        }

        @java.lang.SuppressWarnings("all")
        public static class GrpcMethodBuilder {
          @java.lang.SuppressWarnings("all")
          private String name;

          @java.lang.SuppressWarnings("all")
          GrpcMethodBuilder() {}

          /**
           * @return {@code this}.
           */
          @java.lang.SuppressWarnings("all")
          public GRpcActuateAutoConfiguration.GrpcEndpoint.GRpcServices.GrpcMethod.GrpcMethodBuilder
              name(final String name) {
            this.name = name;
            return this;
          }

          @java.lang.SuppressWarnings("all")
          public GRpcActuateAutoConfiguration.GrpcEndpoint.GRpcServices.GrpcMethod build() {
            return new GRpcActuateAutoConfiguration.GrpcEndpoint.GRpcServices.GrpcMethod(this.name);
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          public java.lang.String toString() {
            return "GRpcActuateAutoConfiguration.GrpcEndpoint.GRpcServices.GrpcMethod.GrpcMethodBuilder(name="
                + this.name
                + ")";
          }
        }

        @java.lang.SuppressWarnings("all")
        public static GRpcActuateAutoConfiguration.GrpcEndpoint.GRpcServices.GrpcMethod
                .GrpcMethodBuilder
            builder() {
          return new GRpcActuateAutoConfiguration.GrpcEndpoint.GRpcServices.GrpcMethod
              .GrpcMethodBuilder();
        }

        @java.lang.SuppressWarnings("all")
        public String getName() {
          return this.name;
        }
      }

      private final List<GrpcService> services;
      int port;

      private GRpcServices(Map<String, BindableService> services, int port) {
        this.port = port;
        this.services =
            services.values().stream()
                .map(
                    s -> {
                      final ServiceDescriptor serviceDescriptor =
                          s.bindService().getServiceDescriptor();
                      return GrpcService.builder()
                          .name(serviceDescriptor.getName())
                          .methods(
                              serviceDescriptor.getMethods().stream()
                                  .map(
                                      m -> GrpcMethod.builder().name(m.getBareMethodName()).build())
                                  .collect(Collectors.toList()))
                          .build();
                    })
                .collect(Collectors.toList());
      }

      @java.lang.SuppressWarnings("all")
      public List<GrpcService> getServices() {
        return this.services;
      }

      @java.lang.SuppressWarnings("all")
      public int getPort() {
        return this.port;
      }
    }

    private final GRpcServicesRegistry registry;
    private int port;

    public GrpcEndpoint(GRpcServicesRegistry registry) {
      this.registry = registry;
    }

    @EventListener
    public void onGrpcServerStarted(GRpcServerInitializedEvent e) {
      port = e.getServer().getPort();
    }

    @ReadOperation
    public GRpcServices services() {
      return new GRpcServices(registry.getBeanNameToServiceBeanMap(), port);
    }
  }
}
