/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.security;

import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.lognet.springboot.grpc.FailureHandlingSupport;
import org.lognet.springboot.grpc.GRpcServicesRegistry;
import org.lognet.springboot.grpc.MessageBlockingServerCallListener;
import org.lognet.springboot.grpc.autoconfigure.GRpcServerProperties;
import org.lognet.springboot.grpc.recovery.GRpcRuntimeExceptionWrapper;
import org.lognet.springboot.grpc.security.AuthenticationSchemeSelector;
import org.lognet.springboot.grpc.security.GrpcSecurity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.Ordered;
import org.springframework.security.access.SecurityMetadataSource;
import org.springframework.security.access.intercept.AbstractSecurityInterceptor;
import org.springframework.security.access.intercept.InterceptorStatusToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.util.SimpleMethodInvocation;

public class SecurityInterceptor
extends AbstractSecurityInterceptor
implements ServerInterceptor,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(SecurityInterceptor.class);
    private static final Context.Key<InterceptorStatusToken> INTERCEPTOR_STATUS_TOKEN = Context.key((String)"INTERCEPTOR_STATUS_TOKEN");
    private static final Context.Key<GrpcMethodInvocation<?, ?>> METHOD_INVOCATION = Context.key((String)"METHOD_INVOCATION");
    private final SecurityMetadataSource securityMetadataSource;
    private final AuthenticationSchemeSelector schemeSelector;
    private GRpcServerProperties.SecurityProperties.Auth authCfg;
    private FailureHandlingSupport failureHandlingSupport;
    private GRpcServicesRegistry registry;

    public SecurityInterceptor(SecurityMetadataSource securityMetadataSource, AuthenticationSchemeSelector schemeSelector) {
        this.securityMetadataSource = securityMetadataSource;
        this.schemeSelector = schemeSelector;
    }

    @Autowired
    public void setGRpcServicesRegistry(GRpcServicesRegistry registry) {
        this.registry = registry;
    }

    @Autowired
    public void setFailureHandlingSupport(@Lazy FailureHandlingSupport failureHandlingSupport) {
        this.failureHandlingSupport = failureHandlingSupport;
    }

    public void setConfig(GRpcServerProperties.SecurityProperties.Auth authCfg) {
        this.authCfg = Optional.ofNullable(authCfg).orElseGet(GRpcServerProperties.SecurityProperties.Auth::new);
    }

    public int getOrder() {
        return Optional.ofNullable(this.authCfg.getInterceptorOrder()).orElse(-2147483647);
    }

    public Class<?> getSecureObjectClass() {
        return GrpcMethodInvocation.class;
    }

    public SecurityMetadataSource obtainSecurityMetadataSource() {
        return this.securityMetadataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        CharSequence authorization = Optional.ofNullable((byte[])headers.get(Metadata.Key.of((String)"Authorization-bin", (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER))).map(auth -> StandardCharsets.UTF_8.decode(ByteBuffer.wrap(auth))).orElse((CharSequence)headers.get(Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER)));
        try {
            Context grpcSecurityContext;
            try {
                grpcSecurityContext = this.setupGRpcSecurityContext(call, headers, next, authorization);
            }
            catch (RuntimeException e) {
                ServerCall.Listener<ReqT> listener = this.fail(next, call, headers, e);
                SecurityContextHolder.getContext().setAuthentication(null);
                return listener;
            }
            catch (Exception e) {
                ServerCall.Listener<ReqT> listener = this.fail(next, call, headers, new GRpcRuntimeExceptionWrapper(e));
                SecurityContextHolder.getContext().setAuthentication(null);
                return listener;
            }
            ServerCall.Listener listener = Contexts.interceptCall((Context)grpcSecurityContext, call, (Metadata)headers, this.authenticationPropagatingHandler(next));
            return listener;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(null);
        }
    }

    private <ReqT, RespT> ServerCallHandler<ReqT, RespT> authenticationPropagatingHandler(ServerCallHandler<ReqT, RespT> next) {
        return (call, headers) -> new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(next.startCall(this.afterInvocationPropagator(call), headers)){

            public void onMessage(ReqT message) {
                this.propagateAuthentication(() -> {
                    try {
                        switch (call.getMethodDescriptor().getType()) {
                            case SERVER_STREAMING: 
                            case UNARY: {
                                ((GrpcMethodInvocation)((Object)((Object)METHOD_INVOCATION.get()))).setArguments(new Object[]{message, null});
                                break;
                            }
                            case BIDI_STREAMING: 
                            case CLIENT_STREAMING: 
                            case UNKNOWN: {
                                ((GrpcMethodInvocation)((Object)((Object)METHOD_INVOCATION.get()))).setArguments(new Object[]{message});
                                break;
                            }
                            default: {
                                log.error("Unsupported call type " + call.getMethodDescriptor().getType());
                                throw new StatusRuntimeException(Status.UNAUTHENTICATED);
                            }
                        }
                        SecurityInterceptor.this.beforeInvocation(METHOD_INVOCATION.get());
                        super.onMessage(message);
                    }
                    catch (RuntimeException e) {
                        SecurityInterceptor.this.failureHandlingSupport.closeCall(e, call, headers);
                    }
                    catch (Exception e) {
                        SecurityInterceptor.this.failureHandlingSupport.closeCall(new GRpcRuntimeExceptionWrapper(e), call, headers);
                    }
                    finally {
                        ((GrpcMethodInvocation)((Object)((Object)METHOD_INVOCATION.get()))).setArguments(null);
                    }
                });
            }

            public void onHalfClose() {
                try {
                    this.propagateAuthentication(() -> super.onHalfClose());
                }
                finally {
                    SecurityInterceptor.this.finallyInvocation((InterceptorStatusToken)INTERCEPTOR_STATUS_TOKEN.get());
                }
            }

            public void onCancel() {
                this.propagateAuthentication(() -> super.onCancel());
            }

            public void onComplete() {
                this.propagateAuthentication(() -> super.onComplete());
            }

            public void onReady() {
                this.propagateAuthentication(() -> super.onReady());
            }

            private void propagateAuthentication(Runnable runnable) {
                try {
                    SecurityContextHolder.getContext().setAuthentication((Authentication)GrpcSecurity.AUTHENTICATION_CONTEXT_KEY.get());
                    runnable.run();
                }
                finally {
                    SecurityContextHolder.clearContext();
                }
            }
        };
    }

    private <RespT, ReqT> ServerCall<RespT, ReqT> afterInvocationPropagator(ServerCall<RespT, ReqT> call) {
        return new ForwardingServerCall.SimpleForwardingServerCall<RespT, ReqT>(call){

            public void sendMessage(ReqT message) {
                super.sendMessage(SecurityInterceptor.this.afterInvocation((InterceptorStatusToken)INTERCEPTOR_STATUS_TOKEN.get(), message));
            }
        };
    }

    private <RespT, ReqT> Context setupGRpcSecurityContext(ServerCall<RespT, ReqT> call, Metadata headers, ServerCallHandler<RespT, ReqT> next, CharSequence authorization) {
        Authentication authentication = null == authorization ? null : this.schemeSelector.getAuthScheme(authorization).orElseThrow(() -> new StatusRuntimeException(Status.UNAUTHENTICATED));
        SecurityContext context = SecurityContextHolder.createEmptyContext();
        context.setAuthentication(authentication);
        SecurityContextHolder.setContext((SecurityContext)context);
        GRpcServicesRegistry.GrpcServiceMethod grpcServiceMethod = this.registry.getGrpServiceMethod(call.getMethodDescriptor());
        GrpcMethodInvocation<RespT, ReqT> methodInvocation = new GrpcMethodInvocation<RespT, ReqT>(grpcServiceMethod, call, headers, next);
        InterceptorStatusToken interceptorStatusToken = this.beforeInvocation(methodInvocation);
        return Context.current().withValue(GrpcSecurity.AUTHENTICATION_CONTEXT_KEY, (Object)SecurityContextHolder.getContext().getAuthentication()).withValue(INTERCEPTOR_STATUS_TOKEN, (Object)interceptorStatusToken).withValue(METHOD_INVOCATION, methodInvocation);
    }

    private <RespT, ReqT> ServerCall.Listener<ReqT> fail(ServerCallHandler<ReqT, RespT> next, final ServerCall<ReqT, RespT> call, final Metadata headers, final RuntimeException exception) throws RuntimeException {
        if (this.authCfg.isFailFast()) {
            this.failureHandlingSupport.closeCall(exception, call, headers);
            return new ServerCall.Listener<ReqT>(){};
        }
        return new MessageBlockingServerCallListener<ReqT>(next.startCall(call, headers)){

            public void onMessage(ReqT message) {
                this.blockMessage();
                SecurityInterceptor.this.failureHandlingSupport.closeCall(exception, call, headers, b -> b.request(message));
            }
        };
    }

    static class GrpcMethodInvocation<ReqT, RespT>
    extends SimpleMethodInvocation {
        private final ServerCall<ReqT, RespT> call;
        private final Metadata headers;
        private final ServerCallHandler<ReqT, RespT> next;
        private Object[] arguments;

        public GrpcMethodInvocation(GRpcServicesRegistry.GrpcServiceMethod serviceMethod, ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
            super((Object)serviceMethod.getService(), serviceMethod.getMethod(), new Object[0]);
            this.call = call;
            this.headers = headers;
            this.next = next;
        }

        public Object proceed() {
            return this.next.startCall(this.call, this.headers);
        }

        ServerCall<ReqT, RespT> getCall() {
            return this.call;
        }

        public Object[] getArguments() {
            return this.arguments;
        }

        public void setArguments(Object[] arguments) {
            this.arguments = arguments;
        }
    }
}

